(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    109063,       2813]
NotebookOptionsPosition[    103048,       2643]
NotebookOutlinePosition[    103485,       2660]
CellTagsIndexPosition[    103442,       2657]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["3", "BookChapterNumber",
 CellChangeTimes->{
  3.4920561492443895`*^9, {3.495889608265625*^9, 3.495889608296875*^9}}],

Cell["\:0422\:0435\:043e\:0440\:0435\:0442\:0438\:043a\:043e-\:0447\:0438\
\:0441\:043b\:043e\:0432\:044b\:0435 \:0444\:0443\:043d\:043a\:0446\:0438\
\:0438", "BookChapterTitle",
 CellChangeTimes->{{3.4920561673715897`*^9, 3.4920561814583893`*^9}, {
  3.495889612*^9, 3.495889618671875*^9}}],

Cell[CellGroupData[{

Cell["\:042d\:043b\:0435\:043c\:0435\:043d\:0442\:0430\:0440\:043d\:044b\:0435\
 \:0444\:0443\:043d\:043a\:0446\:0438\:0438", "Section",
 CellChangeTimes->{{3.4920562204115896`*^9, 3.49205622552839*^9}, {
  3.495889731*^9, 3.49588974003125*^9}, {3.49664639103125*^9, 
  3.49664639103125*^9}}],

Cell["\:0426\:0435\:043b\:0430\:044f \:0438 \:0434\:0440\:043e\:0431\:043d\
\:0430\:044f \:0447\:0430\:0441\:0442\:044c", "Subsection",
 CellChangeTimes->{
  3.495890247609375*^9, 3.495976824671875*^9, {3.496582798*^9, 
   3.496582798*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0412\:0430\:0436\:043d\:0443\:044e \:0440\:043e\:043b\:044c \:0432 \
\:0442\:0435\:043e\:0440\:0438\:0438 \:0447\:0438\:0441\:0435\:043b \:0438\
\:0433\:0440\:0430\:0435\:0442 \:0444\:0443\:043d\:043a\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "x", "]"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:043d\:0430\:0437\:044b\:0432\:0430\:0435\:043c\:0430\:044f",
 StyleBox[" \:0446\:0435\:043b\:043e\:0439 \:0447\:0430\:0441\:0442\:044c\
\:044e ",
  FontSlant->"Italic"],
 "\:0438 \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:043c\:0430\
\:044f \:0434\:043b\:044f \:043b\:044e\:0431\:043e\:0433\:043e \:0434\:0435\
\:0439\:0441\:0442\:0432\:0438\:0442\:0435\:043b\:044c\:043d\:043e\:0433\:043e\
 \:0447\:0438\:0441\:043b\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Element]", "\[DoubleStruckCapitalR]"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043a\:0430\:043a \:043d\:0430\:0438\:0431\:043e\:043b\:044c\:0448\:0435\
\:0435 \:0446\:0435\:043b\:043e\:0435, \:043d\:0435 \:043f\:0440\:0435\:0432\
\:043e\:0441\:0445\:043e\:0434\:044f\:0449\:0435\:0435 ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:0412 ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "\:0446\:0435\:043b\:0430\:044f \:0447\:0430\:0441\:0442\:044c \:043c\:043e\
\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \:0432\:044b\:0447\:0438\:0441\
\:043b\:0435\:043d\:0430 \:043f\:0440\:0438 \:043f\:043e\:043c\:043e\:0449\
\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 ",
 StyleBox["Floor",
  FontWeight->"Bold"],
 ", \:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.49589026490625*^9, 3.495890269671875*^9}, {
   3.496579989234375*^9, 3.49658004525*^9}, {3.4965800875*^9, 
   3.496580126515625*^9}, {3.49658044396875*^9, 3.496580511359375*^9}, {
   3.496580629546875*^9, 3.49658064496875*^9}, {3.49658070040625*^9, 
   3.49658078221875*^9}, {3.4965809718125*^9, 3.496580977390625*^9}, 
   3.496582794921875*^9}],

Cell[BoxData[{
 RowBox[{"Floor", "[", "3.55", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Floor", "[", "112", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Floor", "[", 
  RowBox[{"-", "4.73"}], "]"}]}], "Input",
 CellChangeTimes->{{3.496580523421875*^9, 3.4965805601875*^9}, {
  3.49658063396875*^9, 3.4965806585*^9}}],

Cell[TextData[{
 "\:0418\:043d\:043e\:0433\:0434\:0430 \:0440\:0430\:0441\:0441\:043c\:0430\
\:0442\:0440\:0438\:0432\:0430\:0435\:0442\:0441\:044f \:0442\:0430\:043a\
\:0436\:0435 \:043d\:0435\:043e\:0442\:0440\:0438\:0446\:0430\:0442\:0435\
\:043b\:044c\:043d\:0430\:044f \:0444\:0443\:043d\:043a\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", "x", "}"}], " ", "=", " ", 
    RowBox[{"x", "-", 
     RowBox[{"[", "x", "]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:043d\:0430\:0437\:044b\:0432\:0430\:0435\:043c\:0430\:044f ",
 StyleBox["\:0434\:0440\:043e\:0431\:043d\:043e\:0439 \
\:0447\:0430\:0441\:0442\:044c\:044e",
  FontSlant->"Italic"],
 " \:043e\:0442 ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:0412 ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "\:043d\:0435\:0442 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 \:0434\:043b\
\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\:044f \:0434\
\:0440\:043e\:0431\:043d\:043e\:0439 \:0447\:0430\:0441\:0442\:0438, \:0441\
\:043e\:043e\:0442\:0432\:0435\:0442\:0441\:0442\:0432\:0443\:044e\:0449\:0435\
\:0439 \:0434\:0430\:043d\:043d\:043e\:043c\:0443 \:043e\:043f\:0440\:0435\
\:0434\:0435\:043b\:0435\:043d\:0438\:044e. ",
 "\:042d\:0442\:043e \:043e\:0431\:044a\:044f\:0441\:043d\:044f\:0435\:0442\
\:0441\:044f \:0442\:0435\:043c, \:0447\:0442\:043e \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:043f\:0440\:0438\:043d\:044f\:0442\:043e \:0434\:0440\:0443\:0433\:043e\
\:0435 \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:0438\:0435 \
\:0446\:0435\:043b\:043e\:0439 \:0447\:0430\:0441\:0442\:0438 ",
 Cell[BoxData[
  FormBox["-", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:044d\:0442\:043e \:043d\:0430\:0438\:043c\:0435\:043d\:044c\:0448\:0435\
\:0435 \:043f\:043e \:043c\:043e\:0434\:0443\:043b\:044e \:0446\:0435\:043b\
\:043e\:0435, \:043d\:0435 \:043f\:0440\:0435\:0432\:043e\:0441\:0445\:043e\
\:0434\:044f\:0449\:0435\:0435 \:0434\:0430\:043d\:043d\:043e\:0435 \:0447\
\:0438\:0441\:043b\:043e. \:0414\:043b\:044f \:0442\:0430\:043a\:043e\:0433\
\:043e \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:0438\:044f \
\:0432 ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "\:0438\:043c\:0435\:0435\:0442\:0441\:044f \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ",
 StyleBox["IntegerPart, ",
  FontWeight->"Bold"],
 "\:043e\:0434\:043d\:0430\:043a\:043e \:043e\:043d\:0430 \:043d\:0435 \:0441\
\:043e\:043e\:0442\:0432\:0435\:0442\:0441\:0442\:0432\:0443\:0435\:0442 \
\:0434\:0430\:043d\:043d\:043e\:043c\:0443 \:0432 \:043d\:0430\:0447\:0430\
\:043b\:0435 \:043f\:0430\:0440\:0430\:0433\:0440\:0430\:0444\:0430 \:043e\
\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:0438\:044e, \:043d\:0430\
\:043f\:0440\:0438\:043c\:0435\:0440, \:0434\:043b\:044f"
}], "Text",
 CellChangeTimes->{{3.496580926984375*^9, 3.496580969078125*^9}, {
  3.49658102425*^9, 3.49658107546875*^9}, {3.49658113984375*^9, 
  3.49658120265625*^9}, {3.496581236859375*^9, 3.49658135559375*^9}, {
  3.496581484328125*^9, 3.49658149403125*^9}, {3.4965819781875*^9, 
  3.496581983828125*^9}}],

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"-", "4.73"}], "]"}]], "Input",
 CellChangeTimes->{{3.496580889578125*^9, 3.4965809115625*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f \:0442\:0430\:043a \:043e\:043f\:0440\:0435\:0434\:0435\
\:043b\:0435\:043d\:043d\:043e\:0446 \:0446\:0435\:043b\:043e\:0439 \:0447\
\:0430\:0441\:0442\:0438 \:0435\:0441\:0442\:044c \:0442\:0430\:043a\:0436\
\:0435 \:0441\:043e\:043e\:0442\:0432\:0435\:0442\:0441\:0442\:0432\:0443\
\:044e\:0449\:0430\:044f \:0435\:0439 \:0434\:0440\:043e\:0431\:043d\:0430\
\:044f \:0447\:0430\:0441\:0442\:044c, \:043a\:043e\:0442\:043e\:0440\:0430\
\:044f \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \:0432\:044b\
\:0447\:0438\:0441\:043b\:0435\:043d\:0430 \:0444\:0443\:043d\:043a\:0446\
\:0438\:0435\:0439 ",
 StyleBox["FractionalPart",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.496581368703125*^9, 3.49658142078125*^9}}],

Cell[BoxData[{
 RowBox[{"FractionalPart", "[", "3.55", "]"}], "\[IndentingNewLine]", 
 RowBox[{"FractionalPart", "[", 
  RowBox[{"-", "4.73"}], "]"}]}], "Input",
 CellChangeTimes->{{3.496581434828125*^9, 3.496581453203125*^9}}],

Cell["\<\
\:0417\:0430\:043c\:0435\:0442\:0438\:043c, \:0447\:0442\:043e \:0434\:0440\
\:043e\:0431\:043d\:0430\:044f \:0447\:0430\:0441\:0442\:044c \:0432 \:044d\
\:0442\:043e\:043c \:0441\:043b\:0443\:0447\:0430\:0435 \:043c\:043e\:0436\
\:0435\:0442 \:043f\:0440\:0438\:043d\:0438\:043c\:0430\:0442\:044c \:0442\
\:0430\:043a\:0436\:0435 \:0438 \:043e\:0442\:0440\:0438\:0446\:0430\:0442\
\:0435\:043b\:044c\:043d\:044b\:0435 \:0437\:043d\:0430\:0447\:0435\:043d\
\:0438\:044f.\
\>", "Text",
 CellChangeTimes->{{3.496581509828125*^9, 3.49658156225*^9}}],

Cell[TextData[{
 "\:0412 \:0437\:0430\:043f\:0430\:0434\:043d\:043e\:0439 \:043b\:0438\:0442\
\:0435\:0440\:0430\:0442\:0443\:0440\:0435 \:0442\:0430\:043a\:0436\:0435 \
\:043f\:0440\:0438\:043d\:044f\:0442\:044b \:0431\:043e\:043b\:0435\:0435 \
\:0442\:043e\:043d\:043a\:0438\:0435 \:043e\:0431\:043e\:0437\:043d\:0430\
\:0447\:0435\:043d\:0438\:044f \:0434\:043b\:044f \:0440\:0430\:0437\:043d\
\:044b\:0445 \:0432\:0438\:0434\:043e\:0432 \:0446\:0435\:043b\:044b\:0445 \
\:0447\:0430\:0441\:0442\:0435\:0439, \:043f\:043e\:0434\:0434\:0435\:0440\
\:0436\:0438\:0432\:0430\:0435\:043c\:044b\:0435 \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.496581591421875*^9, 3.496581638328125*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[LeftFloor]", "x", "\[RightFloor]"}], " ", "-", " ", 
           RowBox[{
           "\:043d\:0438\:0436\:043d\:044f\:044f", " ", 
            "\:0446\:0435\:043b\:0430\:044f", " ", 
            "\:0447\:0430\:0441\:0442\:044c"}]}], ",", " ", 
          RowBox[{
           RowBox[{
           "\:0441\:043e\:043e\:0442\:0432\:0435\:0441\:0442\:0432\:0443\:0435\
\:0442", " ", 
            "\:043a\:043b\:0430\:0441\:0441\:0438\:0447\:0435\:0441\:043a\
\:043e\:043c\:0443", " ", 
            "\:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:0438\
\:044e"}], ";", " ", 
           RowBox[{"\:0444\:0443\:043d\:043a\:0446\:0438\:044f", " ", 
            StyleBox["Floor",
             FontWeight->"Bold"]}]}]}], 
         StyleBox[" ",
          FontWeight->"Bold"], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"\[LeftCeiling]", "x", "\[RightCeiling]"}], " ", "-", " ", 
           RowBox[{
           "\:0432\:0435\:0440\:0445\:043d\:044f\:044f", " ", 
            "\:0446\:0435\:043b\:0430\:044f", " ", 
            "\:0447\:0430\:0441\:0442\:044c"}]}], ",", " ", 
          RowBox[{
          "\:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:043c\:0430\
\:044f", " ", "\:043a\:0430\:043a", " ", 
           "\:043d\:0430\:0438\:043c\:0435\:043d\:044c\:0448\:0435\:0435", 
           " ", "\:0446\:0435\:043b\:043e\:0435"}], ",", 
          RowBox[{
           RowBox[{
           "\:0431\:043e\:043b\:044c\:0448\:0435\:0435", " ", 
            "\:0438\:043b\:0438", " ", "\:0440\:0430\:0432\:043d\:043e\:0435",
             " ", "x"}], ";", " ", 
           RowBox[{"\:0444\:0443\:043d\:043a\:0446\:0438\:044f", " ", 
            StyleBox["Ceiling",
             FontWeight->"Bold"], 
            StyleBox[
             RowBox[{
              StyleBox[" ",
               FontWeight->"Bold"], " "}]]}]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.49658165040625*^9, 3.496581676078125*^9}, {
  3.4965817150625*^9, 3.496581854390625*^9}, {3.49658192390625*^9, 
  3.496581924125*^9}}],

Cell["\:041f\:0440\:0438\:0432\:0435\:0434\:0435\:043c \:043d\:0435\:0441\
\:043a\:043e\:043b\:044c\:043a\:043e \:043f\:0440\:0438\:043c\:0435\:0440\
\:043e\:0432", "Text",
 CellChangeTimes->{{3.4965818818125*^9, 3.49658189378125*^9}}],

Cell[BoxData[{
 RowBox[{"Floor", "[", "23423.22", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Ceiling", "[", "23423.22", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Floor", "[", "858", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Ceiling", "[", "858", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Floor", "[", 
  RowBox[{"-", "0.221"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Ceiling", "[", 
  RowBox[{"-", "0.221"}], "]"}]}], "Input",
 CellChangeTimes->{{3.496581901546875*^9, 3.49658196721875*^9}, {
   3.496582056890625*^9, 3.4965820636875*^9}, 3.496582178890625*^9}],

Cell[TextData[{
 "\:0425\:0440\:0438\:0441\:0442\:043e\:043c\:0430\:0442\:0438\:0439\:043d\
\:044b\:043c \:043f\:0440\:0438\:043c\:0435\:0440\:043e\:043c \:0438\:0441\
\:043f\:043e\:043b\:044c\:0437\:043e\:0432\:0430\:043d\:0438\:044f \:0446\
\:0435\:043b\:043e\:0439 \:0447\:0430\:0441\:0442\:0438 \:0432 \:0442\:0435\
\:043e\:0440\:0438\:0438 \:0447\:0438\:0441\:0435\:043b \:044f\:0432\:043b\
\:044f\:0435\:0442\:0441\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\
\:043d\:0438\:044f \:0442\:043e\:0447\:043d\:043e\:0439 \:0441\:0442\:0435\
\:043f\:0435\:043d\:0438 \:0432\:0445\:043e\:0436\:0434\:0435\:043d\:0438\
\:044f \:0434\:0430\:043d\:043d\:043e\:0433\:043e \:043f\:0440\:043e\:0441\
\:0442\:043e\:0433\:043e ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0432 \:0447\:0438\:0441\:043b\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "!"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043f\:043e \:0438\:0437\:0432\:0435\:0441\:0442\:043d\:043e\:0439 \:0444\
\:043e\:0440\:043c\:0443\:043b\:0435 "
}], "Text",
 CellChangeTimes->{{3.496582102515625*^9, 3.496582204578125*^9}, {
  3.49658260325*^9, 3.496582606828125*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"[", 
       FractionBox["n", "p"], "]"}], "+", 
      RowBox[{"[", 
       FractionBox["n", 
        SuperscriptBox["p", "2"]], "]"}], "+", 
      RowBox[{"[", 
       FractionBox["n", 
        SuperscriptBox["p", "3"]], "]"}], "+", 
      RowBox[{"\[CenterDot]", "\[CenterDot]", "\[CenterDot]"}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.4965822151875*^9, 3.496582282984375*^9}, {
  3.496644543828125*^9, 3.49664454415625*^9}}],

Cell[TextData[{
 "\:041f\:0440\:043e\:0432\:0435\:0440\:0438\:043c \:0435\:0435 \:0434\:043b\
\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "3", " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "40"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " "
}], "Text",
 CellChangeTimes->{{3.496582295484375*^9, 3.496582315546875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "40"}], ";", " ", 
  RowBox[{"p", "=", "3"}], ";", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{"n", "/", 
      RowBox[{"p", "^", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"Log", "[", 
        RowBox[{"3", ",", "40"}], "]"}], "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"FactorInteger", "[", 
  RowBox[{"n", "!"}], "]"}]}], "Input",
 CellChangeTimes->{{3.496582346796875*^9, 3.4965824899375*^9}, {
  3.496582548796875*^9, 3.496582574125*^9}}]
}, Closed]],

Cell["\<\
\:0421\:0443\:043c\:043c\:044b \:043f\:043e \:0434\:0435\:043b\:0438\:0442\
\:0435\:043b\:044f\:043c: \:0447\:0438\:0441\:043b\:043e \:0434\:0435\:043b\
\:0438\:0442\:0435\:043b\:0435\:0439 \:0438 \:0441\:0443\:043c\:043c\:044b \
\:0438\:0445 \:0441\:0442\:0435\:043f\:0435\:043d\:0435\:0439\
\>", "Subsection",
 CellChangeTimes->{{3.495890041078125*^9, 3.495890043125*^9}, {
  3.495890702421875*^9, 3.4958907024375*^9}, {3.496582802390625*^9, 
  3.49658280240625*^9}, {3.496643453828125*^9, 3.496643479625*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0411\:0443\:0434\:0435\:043c \:0433\:043e\:0432\:043e\:0440\:0438\:0442\
\:044c, \:0447\:0442\:043e \:043e\:0442\:043b\:0438\:0447\:043d\:0430\:044f \
\:043e\:0442 \:0442\:043e\:0436\:0434\:0435\:0441\:0442\:0432\:0435\:043d\
\:043d\:043e\:0433\:043e 0 \:0444\:0443\:043d\:043a\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "(", "x", ")"}], TraditionalForm]]],
 ", \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:043d\:0430\:044f \
\:043d\:0430 \:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:044b\
\:0445 \:0447\:0438\:0441\:043b\:0430\:0445, ",
 StyleBox["\:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\
\:0442\:0438\:0432\:043d\:0430",
  FontSlant->"Italic"],
 ", \:0435\:0441\:043b\:0438 \:0434\:043b\:044f \
\:043b\:044e\:0431\:044b\:0445 \:0432\:0437\:0430\:0438\:043c\:043d\:043e\
\:043f\:0440\:043e\:0441\:0442\:044b\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ",", "b"}], TraditionalForm]]],
 " \:0432\:0435\:0440\:043d\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Theta]", "(", 
     RowBox[{"a", " ", "b"}], ")"}], " ", "=", 
    RowBox[{
     RowBox[{"\[Theta]", "(", "a", ")"}], 
     RowBox[{"\[Theta]", "(", "b", ")"}], " "}]}], TraditionalForm]]],
 ". \:0415\:0441\:043b\:0438 \:0436\:0435 \
\:043f\:043e\:0441\:043b\:0435\:0434\:043d\:0435\:0435 \:0440\:0430\:0432\
\:0435\:043d\:0441\:0442\:0432\:043e \:0432\:0435\:0440\:043d\:043e \:0434\
\:043b\:044f \:0432\:0441\:0435\:0445 a, b, \:0442\:043e \:0431\:0443\:0434\
\:0435\:043c \:043d\:0430\:0437\:044b\:0432\:0430\:0442\:044c \:0444\:0443\
\:043d\:043a\:0446\:0438\:044e",
 StyleBox[" \:0432\:043f\:043e\:043b\:043d\:0435 \:043c\:0443\:043b\:044c\
\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:043e\:0439\
",
  FontSlant->"Italic"],
 ". ",
 "\:0422\:0440\:0438\:0432\:0438\:0430\:043b\:044c\:043d\:044b\:043c \:043f\
\:0440\:0438\:043c\:0435\:0440\:043e\:043c \:0442\:0430\:043a\:043e\:0439 \
\:0444\:0443\:043d\:043a\:0446\:0438\:0438 \:044f\:0432\:043b\:044f\:0435\
\:0442\:0441\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Theta]", "(", "x", ")"}], "=", 
    SuperscriptBox["x", "s"]}], TraditionalForm]]],
 ", \:0434\:043b\:044f \:043b\:044e\:0431\:043e\:0433\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "\[Element]", "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
 " \:0438\:043b\:0438 \:0434\:0430\:0436\:0435 s \[Element] \
\[DoubleStruckCapitalC]. "
}], "Text",
 CellChangeTimes->{
  3.4958907114375*^9, {3.49658267678125*^9, 3.49658291725*^9}, {
   3.49658316115625*^9, 3.496583166140625*^9}}],

Cell[TextData[{
 "\:0427\:0443\:0442\:044c \:043c\:0435\:043d\:0435\:0435 \:0442\:0440\:0438\
\:0432\:0438\:0430\:043b\:044c\:043d\:044b\:043c \:043f\:0440\:0438\:043c\
\:0435\:0440\:043e\:043c \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\
\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:043e\:0439 \:0444\:0443\:043d\
\:043a\:0446\:0438\:0438 \:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f \
\:0444\:0443\:043d\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "(", "x", ")"}], TraditionalForm]]],
 ", \:0440\:0430\:0432\:043d\:0430\:044f \:0447\:0438\:0441\:043b\:0443 \
\:0434\:0435\:043b\:0438\:0442\:0435\:043b\:0435\:0439 ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ". \:041c\:043e\:0436\:043d\:043e \:043f\:043e\:043a\:0430\:0437\:0430\:0442\
\:044c, \:0447\:0442\:043e \:0435\:0441\:043b\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["p", "1"], 
       SubscriptBox["\[Alpha]", "1"]], "..."}], 
     SuperscriptBox[
      SubscriptBox["p", "k"], 
      SubscriptBox["\[Alpha]", "k"]]}]}], TraditionalForm]]],
 " - \:0440\:0430\:0437\:043b\:043e\:0436\:0435\:043d\:0438\:0435 \
\:043d\:0430 \:043f\:0440\:043e\:0441\:0442\:044b\:0435, \:0442\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Tau]", "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Alpha]", "1"], "+", "1"}], ")"}], "..."}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Alpha]", "k"], "+", "1"}], ")"}]}]}], 
   TraditionalForm]]],
 ". \:041e\:0442\:043a\:0443\:0434\:0430 \:043b\:0435\:0433\:043a\:043e \
\:0432\:0438\:0434\:043d\:0430 \:0435\:0435 \:043c\:0443\:043b\:044c\:0442\
\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:043e\:0441\:0442\
\:044c. \:0412 \:0442\:043e \:0436\:0435 \:0432\:0440\:0435\:043c\:044f \
\:043e\:043d\:0430 \:043d\:0435 \:044f\:0432\:043b\:044f\:0435\:0442\:0441\
\:044f \:0432\:043f\:043e\:043b\:043d\:0435 \:043c\:0443\:043b\:044c\:0442\
\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:043e\:0439, \
\:0447\:0442\:043e \:043c\:043e\:0436\:043d\:043e \:0437\:0430\:043c\:0435\
\:0442\:0438\:0442\:044c \:043d\:0430 \:043f\:0440\:0438\:043c\:0435\:0440\
\:0435 \:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0430 \:043f\:0440\:043e\
\:0441\:0442\:043e\:0433\:043e. ",
 "\:0414\:0440\:0443\:0433\:0438\:043c \:043f\:0440\:0438\:043c\:0435\:0440\
\:043e\:043c \:043c\:0443\:043b\:0442\:044c\:0442\:0438\:043f\:043b\:0438\
\:043a\:0430\:0442\:0438\:0432\:043d\:043e\:0439 \:0444\:0443\:043d\:043a\
\:0446\:0438\:0438 \:043c\:043e\:0436\:0435\:0442 \:0441\:043b\:0443\:0436\
\:0438\:0442\:044c \:0444\:0443\:043d\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "(", "x", ")"}], TraditionalForm]]],
 ", \:0440\:0430\:0432\:043d\:0430\:044f \:0441\:0443\:043c\:043c\:0435 \
\:0432\:0441\:0435\:0445 \:0434\:0435\:043b\:0438\:0442\:0435\:043b\:0435\
\:0439 ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{
  3.4958907114375*^9, {3.49658267678125*^9, 3.496583036125*^9}, {
   3.4965831463125*^9, 3.49658323246875*^9}, {3.496583360921875*^9, 
   3.496583456375*^9}, {3.496583540515625*^9, 3.496583714515625*^9}, {
   3.4965840643125*^9, 3.496584064578125*^9}}],

Cell[TextData[{
 "\:041e\:0431\:0435 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 \[Tau](",
 StyleBox["x",
  FontSlant->"Italic"],
 ") \:0438 ",
 StyleBox["S",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") \:044f\:0432\:043b\:044f\:044e\:0442\:0441\:044f \:0447\:0430\:0441\:0442\
\:043d\:044b\:043c\:0438 \:0441\:043b\:0443\:0447\:0430\:044f\:043c\:0438 \
\:0444\:0443\:043d\:043a\:0446\:0438\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Sigma]", "k"], "(", "x", ")"}], ",", " ", 
    RowBox[{"k", "=", "0"}], ",", 
    RowBox[{"1", "..."}]}], TraditionalForm]]],
 ", \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:043c\:043e\:0439 \
\:043a\:0430\:043a \:0441\:0443\:043c\:043c\:0430 ",
 StyleBox["k",
  FontSlant->"Italic"],
 "-\:044b\:0445 \:0441\:0442\:0435\:043f\:0435\:043d\:0435\:0439 \:0432\:0441\
\:0435\:0445 \:0434\:0435\:043b\:0438\:0442\:0435\:043b\:0435\:0439 ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ". \:042d\:0442\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 \
\:043f\:0440\:0438 \:0444\:0438\:043a\:0441\:0438\:0440\:043e\:0432\:0430\
\:043d\:043d\:043e\:043c ",
 StyleBox["k",
  FontSlant->"Italic"],
 " \:0442\:0430\:043a\:0436\:0435 \:044f\:0432\:043b\:044f\:044e\:0442\:0441\
\:044f \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\
\:0442\:0438\:0432\:043d\:044b\:043c\:0438. \:0414\:043b\:044f \:0438\:0445 \
\:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\:044f \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0438\:043c\:0435\:0435\:0442\:0441\:044f \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ",
 StyleBox["DivisorSigma",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.496583817625*^9, 3.4965838344375*^9}, {
   3.49658393259375*^9, 3.496584097625*^9}, 3.49658417984375*^9, {
   3.496584299234375*^9, 3.49658430634375*^9}, {3.496584336859375*^9, 
   3.496584342203125*^9}}],

Cell[BoxData[{
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"0", ",", "100"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"1", ",", "100"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"5", ",", "100"}], "]"}]}], "Input",
 CellChangeTimes->{{3.495890755453125*^9, 3.49589082071875*^9}, {
   3.49589085475*^9, 3.49589094709375*^9}, {3.4958910233125*^9, 
   3.495891112015625*^9}, {3.4958912179375*^9, 3.49589123190625*^9}, {
   3.49589132390625*^9, 3.495891357265625*^9}, {3.49597184234375*^9, 
   3.49597185375*^9}, 3.49597278696875*^9, {3.496583085609375*^9, 
   3.49658308965625*^9}, {3.496584117453125*^9, 3.496584173609375*^9}}],

Cell["\<\
\:041f\:0440\:043e\:0432\:0435\:0440\:0438\:043c \:0438\:0445 \:043c\:0443\
\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\
\:043e\:0441\:0442\:044c\
\>", "Text",
 CellChangeTimes->{{3.496584154578125*^9, 3.496584163984375*^9}}],

Cell[BoxData[{
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"5", ",", "100"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"5", ",", "33"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DivisorSigma", "[", 
   RowBox[{"5", ",", "100"}], "]"}], 
  RowBox[{"DivisorSigma", "[", 
   RowBox[{"5", ",", "33"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"5", ",", 
   RowBox[{"100", "*", "33"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.496584186859375*^9, 3.496584213640625*^9}, {
  3.49658426196875*^9, 3.49658429065625*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\
\:044f \:0431\:043e\:043b\:0435\:0435 \:0441\:043b\:043e\:0436\:043d\:044b\
\:0445 \:0441\:0443\:043c\:043c \:043f\:043e \:0432\:0441\:0435\:043c \:0434\
\:0435\:043b\:0438\:0442\:0435\:043b\:044f\:043c \:0447\:0438\:0441\:043b\
\:0430 \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0438\:043c\:0435\:0435\:0442\:0441\:044f \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ",
 StyleBox["DivisorSum. ",
  FontWeight->"Bold"],
 "\:041f\:0440\:043e\:0432\:0435\:0440\:0438\:043c \:0441 \:0435\:0435 \:043f\
\:043e\:043c\:043e\:0449\:044c\:044e \:0444\:043e\:0440\:043c\:0443\:043b\
\:0443 \:0441\:0443\:043c\:043c\:0438\:0440\:043e\:0432\:0430\:043d\:0438\
\:044f \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\
\:0442\:0438\:0432\:043d\:043e\:0439 \:0444\:0443\:043d\:043a\:0446\:0438\
\:0438 \[Theta](x) \:0434\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["p", "1"], 
       SubscriptBox["\[Alpha]", "1"]], "..."}], 
     SuperscriptBox[
      SubscriptBox["p", "k"], 
      SubscriptBox["\[Alpha]", "k"]]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.496641516734375*^9, 3.49664151925*^9}, {
  3.496641570484375*^9, 3.49664161321875*^9}, {3.49664167909375*^9, 
  3.496641701640625*^9}, {3.496641732765625*^9, 3.496641737609375*^9}, {
  3.49664180090625*^9, 3.496641842984375*^9}, {3.4966418880625*^9, 
  3.49664189646875*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          UnderscriptBox["\[Sum]", 
           RowBox[{" ", 
            RowBox[{"d", " ", "|", "  ", "n"}]}]], 
          RowBox[{"\[Theta]", "(", "d", ")"}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[Theta]", "(", 
          SubscriptBox["p", "1"], ")"}], "+", 
         RowBox[{"\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
          RowBox[{"+", 
           RowBox[{"\[Theta]", "(", 
            SuperscriptBox[
             SubscriptBox["p", "1"], 
             SubscriptBox["\[Alpha]", "1"]], ")"}]}]}]}], ")"}], 
       "\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[Theta]", "(", 
          SubscriptBox["p", "k"], ")"}], "+", 
         RowBox[{"\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
          RowBox[{"+", 
           RowBox[{"\[Theta]", "(", 
            SuperscriptBox[
             SubscriptBox["p", "k"], 
             SubscriptBox["\[Alpha]", "k"]], ")"}]}]}]}], ")"}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496641849515625*^9, 3.496641977140625*^9}, {
  3.49664453578125*^9, 3.49664455565625*^9}}],

Cell[TextData[{
 "\:043d\:0430 \:043f\:0440\:0438\:043c\:0435\:0440\:0435 \:0444\:0443\:043d\
\:043a\:0446\:0438\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Theta]", "(", "x", ")"}], "=", 
    RowBox[{"\[Tau]", "(", "x", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.496641994234375*^9, 3.496641999171875*^9}, {
  3.496642038265625*^9, 3.49664208140625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";", 
  RowBox[{"\[Theta]", " ", "=", " ", 
   RowBox[{
    RowBox[{"DivisorSigma", "[", 
     RowBox[{"0", ",", "#"}], "]"}], "&"}]}], ";", 
  RowBox[{"DivisorSum", "[", 
   RowBox[{"n", ",", "\[Theta]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"FactorInteger", "[", "n", "]"}]}], ";", " ", 
  RowBox[{"P", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", " ", 
    RowBox[{"i", "<=", 
     RowBox[{"Length", "[", "A", "]"}]}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"s", "=", "0"}], " ", ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", "0"}], ",", 
       RowBox[{"j", "<=", 
        RowBox[{
         RowBox[{"A", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"j", "++"}], ",", 
       RowBox[{"s", "+=", " ", 
        RowBox[{"\[Theta]", "[", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"A", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ")"}], "j"], "]"}]}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"P", "*=", "s"}]}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", "P"}], "Input",
 CellChangeTimes->{
  3.496584145859375*^9, {3.4966417438125*^9, 3.49664177440625*^9}, {
   3.496642087640625*^9, 3.49664212803125*^9}, {3.49664216025*^9, 
   3.4966421656875*^9}, {3.496642241953125*^9, 3.496642290703125*^9}, {
   3.49664234403125*^9, 3.49664237525*^9}, {3.49664241415625*^9, 
   3.496642685359375*^9}, {3.496642737046875*^9, 3.4966429079375*^9}, {
   3.496642942484375*^9, 3.496643081328125*^9}, {3.496643112375*^9, 
   3.49664312146875*^9}, {3.496643168328125*^9, 3.4966433255625*^9}, {
   3.4966433618125*^9, 3.4966434108125*^9}}]
}, Closed]],

Cell["\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:041c\:0435\:0431\:0438\
\:0443\:0441\:0430", "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited},
 CellChangeTimes->{{3.495890064171875*^9, 3.495890067671875*^9}, {
  3.495971869125*^9, 3.495971869125*^9}, {3.496583080796875*^9, 
  3.496583083046875*^9}, {3.496645415265625*^9, 3.496645415265625*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 StyleBox["\t\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:041c\:0451\:0431\
\:0438\:0443\:0441\:0430",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", "(", "x", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:0442\:0441\:044f \
\:0434\:043b\:044f \:0432\:0441\:0435\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        SubscriptBox["p", "1"], 
        SubscriptBox["\[Alpha]", "1"]], "..."}], 
      SuperscriptBox[
       SubscriptBox["p", "k"], 
       SubscriptBox["\[Alpha]", "k"]]}], "\[Element]", 
     "\[DoubleStruckCapitalN]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0438\:043c \:043e\:0431\:0440\
\:0430\:0437\:043e\:043c"
}], "Text",
 CellChangeTimes->{
  3.496643602609375*^9, {3.496644426625*^9, 3.4966444268125*^9}, 
   3.496645414046875*^9}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"\[Mu]", "(", "x", ")"}], "=", GridBox[{
        {
         RowBox[{"\[Piecewise]", GridBox[{
            {"0", 
             RowBox[{"\:0435\:0441\:043b\:0438", " ", 
              RowBox[{"\[Exists]", 
               RowBox[{"i", ":", 
                RowBox[{
                 SubscriptBox["\[Alpha]", "i"], ">", "1"}]}]}]}]},
            {
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "k"], 
             RowBox[{
              RowBox[{"\:0435\:0441\:043b\:0438", " ", 
               SubscriptBox["\[Alpha]", "1"]}], "=", 
              RowBox[{
               RowBox[{"\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
                RowBox[{"=", 
                 SubscriptBox["\[Alpha]", "k"]}]}], "=", "1"}]}]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496644343984375*^9, 3.4966443968125*^9}, {
  3.496644431453125*^9, 3.49664453046875*^9}}],

Cell[TextData[{
 "\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:041c\:0451\:0431\:0438\:0443\
\:0441\:0430 \:0442\:0430\:043a\:0436\:0435 \:043c\:0443\:043b\:044c\:0442\
\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:0430, \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:043e\:043d\:0430 \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \
\:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0430 \:043f\:0440\:0438 \
\:043f\:043e\:043c\:043e\:0449\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\
\:0438 ",
 StyleBox["MoebiusMu",
  FontWeight->"Bold"],
 ", \:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.4966445766875*^9, 3.49664459578125*^9}, {
  3.49664548253125*^9, 3.49664549790625*^9}}],

Cell[BoxData[{
 RowBox[{"MoebiusMu", "[", "9", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MoebiusMu", "[", "1111111", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MoebiusMu", "[", "105", "]"}]}], "Input",
 CellChangeTimes->{{3.495971918734375*^9, 3.495971946828125*^9}, 
   3.496583086765625*^9, {3.496644601875*^9, 3.496644708828125*^9}}],

Cell[TextData[{
 "\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:041c\:0451\:0431\:0438\:0443\
\:0441\:0430 \:0438\:0433\:0440\:0430\:0435\:0442 \:0432\:0430\:0436\:043d\
\:0443\:044e \:0440\:043e\:043b\:044c \:0432 \:0442\:0435\:043e\:0440\:0438\
\:0438 \:0447\:0438\:0441\:0435\:043b, \:043e\:043d\:0430 \:043f\:043e\:0437\
\:0432\:043e\:043b\:044f\:0435\:0442 \:043e\:0431\:0440\:0430\:0449\:0430\
\:0442\:044c \:0441\:0443\:043c\:043c\:044b \:043f\:043e \:0434\:0435\:043b\
\:0438\:0442\:0435\:043b\:044f\:043c \:0437\:043d\:0430\:0447\:0435\:043d\
\:0438\:0439 \:0434\:0440\:0443\:0433\:0438\:0445 \:0444\:0443\:043d\:043a\
\:0446\:0438\:0439 \:043f\:0440\:0438 \:043f\:043e\:043c\:043e\:0449\:0438 \
\:0442\:0430\:043a \:043d\:0430\:0437\:044b\:0432\:0430\:0435\:043c\:043e\
\:0439 ",
 StyleBox["\:0444\:043e\:0440\:043c\:0443\:043b\:044b \
\:043e\:0431\:0440\:0430\:0449\:0435\:043d\:0438\:044f \:041c\:0451\:0431\
\:0438\:0443\:0441\:0430. ",
  FontSlant->"Italic"],
 " \:0412 \:043f\:0440\:043e\:0441\:0442\:0435\:0439\:0448\:0435\:043c \:0441\
\:043b\:0443\:0447\:0430\:0435 \:0434\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ",", 
    RowBox[{"g", ":", " ", 
     RowBox[{
     "\[DoubleStruckCapitalN]", "\[RightArrow]", 
      "\[DoubleStruckCapitalC]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043e\:043d\:0430 \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \
\:0441\:0444\:043e\:0440\:043c\:0443\:043b\:0438\:0440\:043e\:0432\:0430\:043d\
\:0430 \:0442\:0430\:043a"
}], "Text",
 CellChangeTimes->{{3.496644762390625*^9, 3.49664489003125*^9}, 
   3.49664492284375*^9, {3.49664504571875*^9, 3.496645310015625*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         FormBox[
          RowBox[{
           RowBox[{"g", "(", "n", ")"}], "=", 
           RowBox[{
            UnderscriptBox["\[Sum]", 
             RowBox[{" ", 
              RowBox[{"d", " ", "|", " ", "n"}]}]], 
            RowBox[{"f", "(", "n", ")"}]}]}],
          TraditionalForm], " ", "\[DoubleLeftRightArrow]", 
         RowBox[{
          FormBox[
           RowBox[{
            RowBox[{"f", "(", "n", ")"}], "=", " ", 
            RowBox[{
             SubscriptBox["\[Sum]", 
              RowBox[{" ", 
               RowBox[{"d", " ", "|", " ", "n"}]}]], 
             RowBox[{
              RowBox[{"\[Mu]", "(", "d", ")"}], 
              RowBox[{"g", "(", 
               FractionBox["n", "d"], ")"}]}]}]}],
           TraditionalForm], "."}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.49664531846875*^9, 3.496645337890625*^9}}]
}, Closed]],

Cell["\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:042d\:0439\:043b\:0435\
\:0440\:0430", "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited},
 CellChangeTimes->{{3.495890064171875*^9, 3.495890067671875*^9}, {
  3.495971869125*^9, 3.495971869125*^9}, {3.496645416796875*^9, 
  3.496645416796875*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t",
 StyleBox["\:0424\:0443\:043d\:043a\:0446\:0438\:044f \
\:042d\:0439\:043b\:0435\:0440\:0430 ",
  FontSlant->"Italic"],
 "\[CurlyPhi]",
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:0442\:0441\:044f \
\:0434\:043b\:044f \:0432\:0441\:0435\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Element]", "\[DoubleStruckCapitalN]"}], TraditionalForm]]],
 " \:043a\:0430\:043a \:043a\:043e\:043b\:0438\:0447\:0435\:0441\:0442\:0432\
\:043e \:0447\:0438\:0441\:0435\:043b \:0440\:044f\:0434\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", 
    RowBox[{
     RowBox[{"...", "x"}], "-", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0432\:0437\:0430\:0438\:043c\:043d\:043e \:043f\:0440\:043e\:0441\:0442\
\:044b\:0445 \:0441 ",
 StyleBox["x. ",
  FontSlant->"Italic"],
 "\:0424\:0443\:043d\:043a\:0446\:0438\:044f \:042d\:0439\:043b\:0435\:0440\
\:0430 \:043e\:043f\:044f\:0442\:044c \:0436\:0435 \:043c\:0443\:043b\:044c\
\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:0430, \
\:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:043e\:043d\:0430 \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \
\:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0430 \:043f\:0440\:0438 \
\:043f\:043e\:043c\:043e\:0449\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\
\:0438 ",
 StyleBox["EulerPhi",
  FontWeight->"Bold"],
 ", \:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.495971911484375*^9, 3.495971915*^9}, {
  3.49664537196875*^9, 3.496645440453125*^9}, {3.496645512453125*^9, 
  3.49664555609375*^9}, {3.49664559021875*^9, 3.496645652296875*^9}, {
  3.496645789046875*^9, 3.496645795734375*^9}}],

Cell[BoxData[{
 RowBox[{"EulerPhi", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EulerPhi", "[", "17", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EulerPhi", "[", "100", "]"}]}], "Input",
 CellChangeTimes->{{3.495971918734375*^9, 3.495971946828125*^9}, {
  3.496645656234375*^9, 3.4966456671875*^9}, {3.49664570065625*^9, 
  3.496645702015625*^9}}],

Cell["\<\
\:041f\:043e \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\
\:0430\:0442\:0438\:0432\:043d\:043e\:0441\:0442\:0438 \:043b\:0435\:0433\
\:043a\:043e \:043f\:043e\:043b\:0443\:0447\:0438\:0442\:044c \:0444\:043e\
\:0440\:043c\:0443\:043b\:0443 \:0434\:043b\:044f \:0444\:0443\:043d\:043a\
\:0446\:0438\:0438 \:042d\:0439\:043b\:0435\:0440\:0430\
\>", "Text",
 CellChangeTimes->{{3.4966457038125*^9, 3.496645746140625*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{GridBox[{
         {
          RowBox[{
           RowBox[{"\[CurlyPhi]", "(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               SubscriptBox["p", "1"], 
               SubscriptBox["\[Alpha]", "1"]], "..."}], 
             SuperscriptBox[
              SubscriptBox["p", "k"], 
              SubscriptBox["\[Alpha]", "k"]]}], ")"}], "="}]}
        },
        GridBoxAlignment->{"Columns" -> {{"Center"}}}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["p", "1"], 
           SubscriptBox["\[Alpha]", "1"]], "-", 
          SuperscriptBox[
           SubscriptBox["p", "1"], 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], "-", "1"}]]}], ")"}], 
        "\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["p", "k"], 
           SubscriptBox["\[Alpha]", "k"]], "-", 
          SuperscriptBox[
           SubscriptBox["p", "k"], 
           RowBox[{
            SubscriptBox["\[Alpha]", "k"], "-", "1"}]]}], ")"}]}]}], ","}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496645750140625*^9, 3.496645859796875*^9}}],

Cell[TextData[{
 "\:043f\:0440\:043e\:0432\:0435\:0440\:0438\:043c \:0435\:0435 \:043f\:0440\
\:0438 \:043f\:043e\:043c\:043e\:0449\:0438 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.49664586225*^9, 3.49664587278125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "12321"}], ";", " ", 
  RowBox[{"EulerPhi", "[", "n", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"FactorInteger", "[", "n", "]"}]}], ";", " ", 
  RowBox[{"P", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", " ", 
    RowBox[{"i", "<=", 
     RowBox[{"Length", "[", "A", "]"}]}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"P", "*=", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        RowBox[{"A", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], 
       RowBox[{
        RowBox[{"A", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]], "-", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"A", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], 
       RowBox[{
        RowBox[{
         RowBox[{"A", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]]}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", "P"}], "Input",
 CellChangeTimes->{{3.496645877828125*^9, 3.496646013515625*^9}}],

Cell["\<\
\:0418\:0441\:043f\:043e\:043b\:044c\:0437\:0443\:044f \:0444\:043e\:0440\
\:043c\:0443\:043b\:0443 \:043e\:0431\:0440\:0430\:0449\:0435\:043d\:0438\
\:044f \:041c\:0451\:0431\:0438\:0443\:0441\:0430 \:043c\:043e\:0436\:043d\
\:043e \:0442\:0430\:043a\:0436\:0435 \:043f\:043e\:043b\:0443\:0447\:0438\
\:0442\:044c \:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0435\:0435 \:0442\
\:043e\:0436\:0434\:0435\:0441\:0442\:0432\:043e\
\>", "Text",
 CellChangeTimes->{{3.496646108578125*^9, 3.4966461344375*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"\[CurlyPhi]", "(", "n", ")"}], "=", 
          RowBox[{
           SubscriptBox["\[Sum]", 
            RowBox[{" ", 
             RowBox[{"d", " ", "|", "  ", "n"}]}]], 
           RowBox[{
            RowBox[{"\[Mu]", "(", "d", ")"}], " ", 
            FractionBox["n", "d"]}]}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], ","}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496646139140625*^9, 3.4966462705625*^9}}],

Cell["\:043f\:0440\:043e\:0432\:0435\:0440\:0438\:043c \:0435\:0433\:043e", \
"Text",
 CellChangeTimes->{{3.496646218953125*^9, 3.496646228515625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1234321"}], ";", " ", 
  RowBox[{"EulerPhi", "[", "n", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"DivisorSum", "[", 
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"MoebiusMu", "[", "#", "]"}], 
     FractionBox["n", "#"]}], "&"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.49664623828125*^9, {3.49664627596875*^9, 3.496646345984375*^9}}]
}, Closed]],

Cell["\:0417\:0430\:0434\:0430\:0447\:0438", "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited},
 CellChangeTimes->{{3.495889976515625*^9, 3.495889977578125*^9}, {
  3.49664544578125*^9, 3.49664544578125*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 1.",
  FontWeight->"Bold"],
 " \:0414\:043b\:044f \:0432\:0437\:0430\:0438\:043c\:043e\:043f\:0440\:043e\
\:0441\:0442\:044b\:0445 \:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\
\:043d\:044b\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", ",", "n"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043f\:0440\:0435\:0434\:0441\:0442\:0430\:0432\:0438\:0442\:044c \:0441\
\:0443\:043c\:043c\:0443"
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
  3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
  3.495972422234375*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        FormBox[
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{" ", 
            RowBox[{"i", "=", "1"}]}], 
           RowBox[{" ", 
            RowBox[{"n", "-", "1"}]}]], 
          RowBox[{"[", 
           FractionBox[
            RowBox[{"i", " ", "m"}], "n"], "]"}]}],
         TraditionalForm]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.495972404875*^9, 3.495972413609375*^9}}],

Cell[TextData[{
 "\:0432 \:0432\:0438\:0434\:0435 \:043c\:043d\:043e\:0433\:043e\:0447\:043b\
\:0435\:043d\:0430 \:043e\:0442 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", ",", "n"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{3.495972440359375*^9}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 2.",
  FontWeight->"Bold"],
 " \:0414\:043b\:044f \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:043d\:0430\
\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:044b\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", ",", "q"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043f\:0440\:0435\:0434\:0441\:0442\:0430\:0432\:0438\:0442\:044c \:0441\
\:0443\:043c\:043c\:0443"
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
  3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
  3.495972422234375*^9}, {3.495972456515625*^9, 3.4959724685*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         FormBox[
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{" ", 
             RowBox[{"i", "=", "1"}]}], 
            RowBox[{" ", 
             FractionBox[
              RowBox[{"p", "-", "1"}], "2"]}]], 
           RowBox[{"[", 
            FractionBox[
             RowBox[{"i", " ", "q"}], "p"], "]"}]}],
          TraditionalForm]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "+", GridBox[{
        {
         FormBox[
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{" ", 
             RowBox[{"j", "=", "1"}]}], 
            RowBox[{" ", 
             FractionBox[
              RowBox[{"q", "-", "1"}], "2"]}]], 
           RowBox[{"[", 
            FractionBox[
             RowBox[{"j", " ", "p"}], "q"], "]"}]}],
          TraditionalForm]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.495972404875*^9, 3.495972413609375*^9}, {
  3.4959724724375*^9, 3.495972520046875*^9}}],

Cell[TextData[{
 "\:0432 \:0432\:0438\:0434\:0435 \:043c\:043d\:043e\:0433\:043e\:0447\:043b\
\:0435\:043d\:0430 \:043e\:0442 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", ",", "q"}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{
  3.495972440359375*^9, {3.495972475921875*^9, 3.495972478375*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 3.",
  FontWeight->"Bold"],
 " \:0412\:044b\:0447\:0438\:0441\:043b\:0438\:0442\:044c \:043a\:043e\:043b\
\:0438\:0447\:0435\:0441\:0442\:0432\:043e \:043d\:0430\:0442\:0443\:0440\
\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\:0438\:0441\:0435\:043b ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 ", \:043c\:0435\:043d\:044c\:0448\:0438\:0445 \:0437\:0430\:0434\:0430\:043d\
\:043d\:043e\:0439 \:0433\:0440\:0430\:043d\:0438\:0446\:044b, \:0434\:043b\
\:044f \:043a\:043e\:0442\:043e\:0440\:044b\:0445 \:0432\:0435\:0440\:043d\
\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Tau]", "(", "n", ")"}], "=", 
    RowBox[{"\[Tau]", "(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
   3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
   3.495972422234375*^9}, {3.495972456515625*^9, 3.4959724685*^9}, {
   3.495973051015625*^9, 3.495973123546875*^9}, 3.49597675815625*^9, {
   3.496583296921875*^9, 3.496583304609375*^9}, {3.49664604484375*^9, 
   3.49664604778125*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 4.",
  FontWeight->"Bold"],
 " \:0414\:043b\:044f \:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\
\:043e\:0433\:043e ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " \:043f\:0440\:0435\:0434\:0441\:0442\:0430\:0432\:0438\:0442\:044c \:0441\
\:0443\:043c\:043c\:0443"
}], "Text",
 CellChangeTimes->{{3.495974481734375*^9, 3.49597452475*^9}, 
   3.49597675921875*^9, 3.4966460456875*^9}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      SubscriptBox["\[Sum]", 
       RowBox[{" ", 
        RowBox[{"\[Delta]", " ", "|", " ", "n"}]}]], " ", 
      RowBox[{
       RowBox[{"\[CurlyPhi]", "(", "\[Delta]", ")"}], 
       RowBox[{"\[Tau]", "(", 
        FractionBox["n", "\[Delta]"], ")"}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.495974622203125*^9, 3.495974644234375*^9}, {
  3.495974677*^9, 3.495974689625*^9}, {3.495974732921875*^9, 
  3.495974784140625*^9}, {3.4965833075625*^9, 3.496583309046875*^9}}],

Cell[TextData[{
 " \:0432 \:0432\:0438\:0434\:0435 \:043c\:043d\:043e\:0433\:043e\:0447\:043b\
\:0435\:043d\:0430 \:043e\:0442 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Sigma]", "k"], "(", "n", ")"}], ",", 
    RowBox[{"k", "=", "0"}], ",", "1", ",", "2"}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.49658332121875*^9, 3.49658332965625*^9}, {
  3.496583901328125*^9, 3.496583904390625*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\:041c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\
\:0438\:0432\:043d\:0430\:044f \:0442\:0435\:043e\:0440\:0438\:044f \:0447\
\:0438\:0441\:0435\:043b", "Section",
 CellChangeTimes->{{3.4920562204115896`*^9, 3.49205622552839*^9}, {
  3.495889731*^9, 3.49588974003125*^9}, {3.49588977546875*^9, 
  3.495889800796875*^9}}],

Cell["\<\
\:041c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\
\:0432\:043d\:044b\:0439 \:043f\:043e\:0440\:044f\:0434\:043e\:043a \:044d\
\:043b\:0435\:043c\:0435\:043d\:0442\:0430\
\>", "Subsection",
 CellChangeTimes->{{3.49589008653125*^9, 3.495890095625*^9}, {
  3.49664656628125*^9, 3.496646566296875*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0414\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalN]"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043e\:0431\:043e\:0437\:043d\:0430\:0447\:0438\:043c ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\
\:0438\:0432\:043d\:0443\:044e \:0433\:0440\:0443\:043f\:043f\:0443 \:0432\
\:044b\:0447\:0435\:0442\:043e\:0432 \:043f\:043e \:043c\:043e\:0434\:0443\
\:043b\:044e ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0442\:043e \:0435\:0441\:0442\:044c \:0432\:0441\:0435 \:043e\:0441\
\:0442\:0430\:0442\:043a\:0438 \:043e\:0442 \:0434\:0435\:043b\:0435\:043d\
\:0438\:044f \:043d\:0430 ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\
\:0438\:0441\:0435\:043b, \:0432\:0437\:0430\:0438\:043c\:043e \:043f\:0440\
\:043e\:0441\:0442\:044b\:0445 \:0441 ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0432\:043c\:0435\:0441\:0442\:0435 \:0441 \
\:043e\:043f\:0435\:0440\:0430\:0446\:0438\:0435\:0439 \:0443\:043c\:043d\
\:043e\:0436\:0435\:043d\:0438\:044f. "
}], "Text",
 CellChangeTimes->{
  3.496646911203125*^9, {3.496646998375*^9, 3.49664699840625*^9}}],

Cell[TextData[{
 "\:041b\:0435\:0433\:043a\:043e \:0432\:0438\:0434\:0435\:0442\:044c, \:0447\
\:0442\:043e \:043f\:043e\:0440\:044f\:0434\:043e\:043a \:044d\:0442\:043e\
\:0439 \:0433\:0440\:0443\:043f\:043f\:044b ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    SuperscriptBox[
     SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"], "|", 
    RowBox[{"=", 
     StyleBox[
      RowBox[{"\[CurlyPhi]", "(", "m", ")"}]]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0438 \:0432\:0435\:0440\:043d\:0430 ",
 StyleBox["\:0442\:0435\:043e\:0440\:0435\:043c\:0430 \
\:042d\:0439\:043b\:0435\:0440\:0430: ",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.496646911203125*^9, {3.496646998375*^9, 3.4966470040625*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{GridBox[{
         {
          RowBox[{"\[ForAll]", 
           RowBox[{"a", "\[Element]"}]}]}
        },
        GridBoxAlignment->{"Columns" -> {{"Center"}}}], 
       SuperscriptBox[
        SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"]}], 
      "\[DoubleRightArrow]", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"\[CurlyPhi]", "(", "m", ")"}]], "\[Congruent]", 
       RowBox[{"1", " ", 
        RowBox[{"(", 
         RowBox[{"mod", " ", "m"}], ")"}]}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.49664691434375*^9, 3.49664698971875*^9}}],

Cell[TextData[{
 StyleBox["(\:041c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\
\:0442\:0438\:0432\:043d\:044b\:043c) \:043f\:043e\:0440\:044f\:0434\:043a\
\:043e\:043c ",
  FontSlant->"Italic"],
 "ord(",
 StyleBox["a",
  FontSlant->"Italic"],
 ") \:044d\:043b\:0435\:043c\:0435\:043d\:0442\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{GridBox[{
      {
       RowBox[{"a", "\[Element]"}]}
     },
     GridBoxAlignment->{"Columns" -> {{"Center"}}}], 
    SuperscriptBox[
     SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"]}], TraditionalForm]]],
 " \:043d\:0430\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f \:043d\:0430\
\:0438\:043c\:0435\:043d\:044c\:0448\:0435\:0435 \:043d\:0430\:0442\:0443\
\:0440\:0430\:043b\:044c\:043d\:043e\:0435 \[Gamma], \:0442\:0430\:043a\:043e\
\:0435 \:0447\:0442\:043e  "
}], "Text",
 CellChangeTimes->{{3.49664704878125*^9, 3.49664711375*^9}, {
  3.49664714865625*^9, 3.496647156703125*^9}, {3.496647208359375*^9, 
  3.4966472134375*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          SuperscriptBox["a", "\[Gamma]"], "\[Congruent]", 
          RowBox[{"1", " ", 
           RowBox[{"(", 
            RowBox[{"mod", " ", "m"}], ")"}]}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "."}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496647166359375*^9, 3.4966471788125*^9}}],

Cell[TextData[{
 "\:0418\:0437 \:0430\:043b\:0433\:0435\:0431\:0440\:044b \:0438\:0437\:0432\
\:0435\:0441\:0442\:043d\:043e, \:0447\:0442\:043e \:043f\:043e\:0440\:044f\
\:0434\:043e\:043a \:044d\:043b\:0435\:043c\:0435\:043d\:0442\:0430 \:0434\
\:0435\:043b\:0438\:0442 \:043f\:043e\:0440\:044f\:0434\:043e\:043a \:0433\
\:0440\:0443\:043f\:043f\:044b, \:043f\:043e\:044d\:0442\:043e\:043c\:0443 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ord", "(", 
     StyleBox["a",
      FontSlant->"Italic"], ")"}], " ", "|", " ", 
    RowBox[{"\[CurlyPhi]", "(", "m", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:0414\:043b\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:043d\
\:0438\:044f \:043f\:043e\:0440\:044f\:0434\:043e\:043a\:0430 \:044d\:043b\
\:0435\:043c\:0435\:043d\:0442\:0430 \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0438\:043c\:0435\:0435\:0442\:0441\:044f \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ",
 StyleBox["MultiplicativeOrder",
  FontWeight->"Bold"],
 ", \:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.496647191171875*^9, 3.49664730503125*^9}}],

Cell[BoxData[{
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"2", ",", "100"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"3", ",", "100"}], "]"}]}], "Input",
 CellChangeTimes->{{3.49597197196875*^9, 3.495971991859375*^9}, {
  3.496646541546875*^9, 3.49664654278125*^9}, {3.496646663046875*^9, 
  3.49664666378125*^9}, {3.496647293125*^9, 3.49664729346875*^9}, {
  3.49664732478125*^9, 3.49664735665625*^9}}],

Cell[TextData[{
 "\:0417\:0430\:043c\:0435\:0442\:0438\:043c, \:0447\:0442\:043e ",
 StyleBox["MultiplicativeOrder",
  FontWeight->"Bold"],
 " \:043d\:0435 \:0440\:0430\:0431\:043e\:0442\:0430\:0435\:0442, \
\:0435\:0441\:043b\:0438 \:0435\:0435 \:0430\:0440\:0433\:0443\:043c\:0435\
\:043d\:0442\:044b \:043d\:0435 \:0432\:0437\:0430\:0438\:043c\:043e \:043f\
\:0440\:043e\:0441\:0442\:044b."
}], "Text",
 CellChangeTimes->{{3.49664738440625*^9, 3.49664738621875*^9}, {
  3.496647462859375*^9, 3.496647491203125*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         SubscriptBox["\[Alpha]", "0"]], 
        SuperscriptBox[
         SubscriptBox["p", "1"], 
         SubscriptBox["\[Alpha]", "1"]]}], "..."}], 
      SuperscriptBox[
       SubscriptBox["p", "k"], 
       SubscriptBox["\[Alpha]", "k"]]}]}], ",", " ", 
    RowBox[{
     SubscriptBox["p", "i"], ">", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0438\:043c ",
 StyleBox["\:0444\:0443\:043d\:043a\:0446\:0438\:044e \
\:041a\:0430\:0440\:043c\:0430\:0439\:043a\:043b\:0430",
  FontSlant->"Italic"],
 " \[Lambda](",
 StyleBox["m",
  FontSlant->"Italic"],
 ") \:043a\:0430\:043a "
}], "Text",
 CellChangeTimes->{{3.4966475705*^9, 3.496647621046875*^9}, {
  3.496647692234375*^9, 3.496647763921875*^9}, {3.49664797896875*^9, 
  3.49664799446875*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"\[Lambda]", "(", "m", ")"}], " ", "=", " ", 
         RowBox[{"\[Piecewise]", GridBox[{
            {
             RowBox[{"\:041d\:041e\:041a", "[", 
              RowBox[{
               FractionBox[
                RowBox[{"\[CurlyPhi]", "(", 
                 SuperscriptBox["2", 
                  SubscriptBox["\[Alpha]", "0"]], ")"}], "2"], ",", 
               RowBox[{"\[CurlyPhi]", "(", 
                SuperscriptBox[
                 SubscriptBox["p", "1"], 
                 SubscriptBox["\[Alpha]", "1"]], ")"}], ",", "...", ",", 
               RowBox[{"\[CurlyPhi]", "(", 
                SuperscriptBox[
                 SubscriptBox["p", "k"], 
                 SubscriptBox["\[Alpha]", "k"]], ")"}]}], "]"}], 
             RowBox[{
              SubscriptBox["\[Alpha]", "0"], ">", "2"}]},
            {
             RowBox[{"\:041d\:041e\:041a", "[", 
              RowBox[{
               RowBox[{"\[CurlyPhi]", "(", 
                SuperscriptBox["2", 
                 SubscriptBox["\[Alpha]", "0"]], ")"}], ",", 
               RowBox[{"\[CurlyPhi]", "(", 
                SuperscriptBox[
                 SubscriptBox["p", "1"], 
                 SubscriptBox["\[Alpha]", "1"]], ")"}], ",", "...", ",", 
               RowBox[{"\[CurlyPhi]", 
                RowBox[{"(", 
                 SuperscriptBox[
                  SubscriptBox["p", "k"], 
                  SubscriptBox["\[Alpha]", "k"]], ")"}]}]}], "]"}], 
             RowBox[{
              RowBox[{
               SubscriptBox["\[Alpha]", "0"], "=", "0"}], ",", "1", ",", "2"}]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496647777734375*^9, 3.496647866484375*^9}, {
  3.49664790665625*^9, 3.4966479486875*^9}}],

Cell[TextData[{
 "\:041d\:0435\:0441\:043b\:043e\:0436\:043d\:043e \:043f\:043e\:043a\:0430\
\:0437\:0430\:0442\:044c, \:0447\:0442\:043e \:0435\:0435 \:0437\:043d\:0430\
\:0447\:0435\:043d\:0438\:0435 \:0440\:0430\:0432\:043d\:043e \:043c\:0430\
\:043a\:0441\:0438\:043c\:0430\:043b\:044c\:043d\:043e\:043c\:0443 \:043f\
\:043e\:0440\:044f\:0434\:043a\:0443 \:044d\:043b\:0435\:043c\:0435\:043d\
\:0442\:0430 \:0432 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"], TraditionalForm]]],
 ". \:0414\:043b\:044f \:0435\:0435 \
\:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\:044f \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0438\:0441\:043f\:043e\:043b\:044c\:0437\:0443\:0435\:0442\:0441\:044f \
\:0444\:0443\:043d\:043a\:0446\:0438\:044f ",
 StyleBox["CarmichaelLambda, ",
  FontWeight->"Bold"],
 "\:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.49664800178125*^9, 3.49664808228125*^9}}],

Cell[BoxData[
 RowBox[{"CarmichaelLambda", "[", "100", "]"}]], "Input",
 CellChangeTimes->{
  3.496647298359375*^9, {3.496648176625*^9, 3.4966481771875*^9}}],

Cell[TextData[{
 "\:0417\:043d\:0430\:0447\:0435\:043d\:0438\:0435 \:0444\:0443\:043d\:043a\
\:0446\:0438\:0438 \:041a\:0430\:0440\:043c\:0430\:0439\:043a\:043b\:0430 \
\[Lambda](",
 StyleBox["m",
  FontSlant->"Italic"],
 "), \:0432\:043e\:043e\:0431\:0449\:0435 \
\:0433\:043e\:0432\:043e\:0440\:044f, \:043c\:0435\:043d\:044c\:0448\:0435 \
\[CurlyPhi](",
 StyleBox["m",
  FontSlant->"Italic"],
 "), \:043f\:043e\:044d\:0442\:043e\:043c\:0443 \:043d\:0435 \:0432\:0441\
\:0435 \:0433\:0440\:0443\:043f\:043f\:044b ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"], TraditionalForm]]],
 " \:0446\:0438\:043a\:043b\:0438\:0447\:0435\:0441\:043a\:0438\:0435, \:043d\
\:0430\:043f\:0440\:0438\:043c\:0435\:0440,"
}], "Text",
 CellChangeTimes->{{3.496648095921875*^9, 3.496648162046875*^9}}],

Cell[BoxData[{
 RowBox[{"EulerPhi", "[", "100", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CarmichaelLambda", "[", "100", "]"}]}], "Input",
 CellChangeTimes->{{3.496648189*^9, 3.4966481961875*^9}, {3.4966482575625*^9, 
  3.49664825975*^9}}]
}, Closed]],

Cell["\:041f\:0435\:0440\:0432\:043e\:043e\:0431\:0440\:0430\:0437\:043d\:044b\
\:0435 \:043a\:043e\:0440\:043d\:0438", "Subsection",
 CellChangeTimes->{{3.49589010628125*^9, 3.49589010953125*^9}, {
  3.496648269*^9, 3.496648269015625*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0418\:0437\:0443\:0447\:0438\:043c \:0442\:0435\:043f\:0435\:0440\:044c \
\:0441\:043b\:0443\:0447\:0430\:0438, \:043a\:043e\:0433\:0434\:0430 \
\[Lambda](",
 StyleBox["m",
  FontSlant->"Italic"],
 ")=\[CurlyPhi](",
 StyleBox["m",
  FontSlant->"Italic"],
 ") \:0438 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["\[DoubleStruckCapitalZ]", "m"], "*"], TraditionalForm]]],
 " \:0446\:0438\:043a\:043b\:0438\:0447\:0435\:0441\:043a\:0430\:044f. \:041e\
\:0431\:0440\:0430\:0437\:0443\:044e\:0449\:0438\:0439 \:044d\:043b\:0435\
\:043c\:0435\:043d\:0442 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:044d\:0442\:043e\:0439 \:0433\:0440\:0443\:043f\:043f\:044b \:043d\:0430\
\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:043f\:0435\:0440\:0432\:043e\:043e\:0431\:0440\:0430\:0437\:043d\
\:044b\:043c \:043a\:043e\:0440\:043d\:0435\:043c, ",
  FontSlant->"Italic"],
 "\:043b\:0435\:0433\:043a\:043e \:0432\:0438\:0434\:0435\:0442\:044c, \:0447\
\:0442\:043e \:0435\:0433\:043e \:043f\:043e\:0440\:044f\:0434\:043e\:043a \
\:0440\:0430\:0432\:0435\:043d \[CurlyPhi](",
 StyleBox["m",
  FontSlant->"Italic"],
 "). \:041c\:043e\:0436\:043d\:043e \
\:043f\:043e\:043a\:0430\:0437\:0430\:0442\:044c, \:0447\:0442\:043e \:043f\
\:0435\:0440\:0432\:043e\:043e\:0431\:0440\:0430\:0437\:043d\:044b\:0435 \
\:043a\:043e\:0440\:043d\:0438 \:0441\:0443\:0449\:0435\:0441\:0442\:0432\
\:0443\:044e\:0442 \:043b\:0438\:0448\:044c \:0434\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", "\[Element]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", 
       SuperscriptBox["p", "\[Alpha]"], ",", 
       RowBox[{"2", 
        SuperscriptBox["p", "\[Alpha]"]}]}], "}"}]}], ",", " ", 
    RowBox[{"\[Alpha]", "\[Element]", "\[DoubleStruckCapitalN]"}], ",", " ", 
    RowBox[{"p", ">", 
     RowBox[{"2", "-", "\:043f\:0440\:043e\:0441\:0442\:043e\:0435"}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". "
}], "Text",
 CellChangeTimes->{{3.49597200496875*^9, 3.4959720058125*^9}, {
  3.496648270953125*^9, 3.496648355796875*^9}, {3.496648394125*^9, 
  3.49664850778125*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f \:0438\:0445 \:043d\:0430\:0445\:043e\:0436\:0434\:0435\
\:043d\:0438\:044f \:0432 \:043d\:0430\:0441\:0442\:043e\:044f\:0449\:0438\
\:0439 \:043c\:043e\:043c\:0435\:043d\:0442 \:043d\:0435 \:0441\:0443\:0449\
\:0435\:0441\:0442\:0432\:0443\:0435\:0442 \:0434\:0435\:0442\:0435\:0440\
\:043c\:0438\:043d\:0438\:0440\:043e\:0432\:0430\:043d\:043d\:044b\:0445 \
\:0430\:043b\:0433\:043e\:0440\:0438\:0442\:043c\:043e\:0432 \:0441 \:0434\
\:043e\:043a\:0430\:0437\:0430\:043d\:043d\:043e\:0439 \:043f\:043e\:043b\
\:0438\:043d\:043e\:043c\:0438\:0430\:043b\:044c\:043d\:043e\:0439 \:043e\
\:0446\:0435\:043d\:043a\:043e\:0439 \:0441\:043b\:043e\:0436\:043d\:043e\
\:0441\:0442\:0438. \:0412 \:0442\:043e \:0436\:0435 \:0432\:0440\:0435\:043c\
\:044f \:0438\:043c\:0435\:044e\:0442\:0441\:044f \:0434\:043e\:0432\:043e\
\:043b\:044c \:044d\:0444\:0444\:0435\:043a\:0442\:0438\:0432\:043d\:044b\
\:0435 \:0432\:0435\:0440\:043e\:044f\:0442\:043d\:043e\:0441\:0442\:043d\
\:044b\:0435 \:0430\:043b\:0433\:043e\:0440\:0438\:043c\:044b, \:043a\:043e\
\:0442\:043e\:0440\:044b\:0435 \:0440\:0435\:0430\:043b\:0438\:0437\:0438\
\:0432\:0430\:043d\:044b \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0432 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 ",
 StyleBox["PrimitiveRoot",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.496648508609375*^9, 3.496648578015625*^9}}],

Cell[BoxData[{
 RowBox[{"PrimitiveRoot", "[", "2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveRoot", "[", "4", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveRoot", "[", "125", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveRoot", "[", "250", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveRoot", "[", "12", "]"}]}], "Input",
 CellChangeTimes->{{3.495972012234375*^9, 3.4959720233125*^9}, {
  3.496648622453125*^9, 3.496648624546875*^9}, {3.49664866753125*^9, 
  3.496648699546875*^9}}],

Cell[TextData[{
 "\:0417\:0430\:043c\:0435\:0442\:0438\:043c, \:0447\:0442\:043e ",
 StyleBox["PrimitiveRoot",
  FontWeight->"Bold"],
 " \:043d\:0435 \:0440\:0430\:0431\:043e\:0442\:0430\:0435\:0442, \
\:0435\:0441\:043b\:0438 \:0435\:0435 \:0430\:0440\:0433\:0443\:043c\:0435\
\:043d\:0442 \:043d\:0435 \:0438\:043c\:0435\:0435\:0442 \:0443\:043a\:0430\
\:0437\:0430\:043d\:043d\:044b\:0439 \:0432\:044b\:0448\:0435 \:0432\:0438\
\:0434."
}], "Text",
 CellChangeTimes->{{3.496648642625*^9, 3.49664866246875*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:0417\:0430\:0434\:0430\:0447\:0438", "Subsection",
 CellChangeTimes->{{3.49589011725*^9, 3.49589011840625*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 1.",
  FontWeight->"Bold"],
 " \:0412\:044b\:0447\:0438\:0441\:043b\:0438\:0442\:044c \:043a\:043e\:043b\
\:0438\:0447\:0435\:0441\:0442\:0432\:043e \:043d\:0435\:0447\:0435\:0442\
\:043d\:044b\:0445 \:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\
\:044b\:0445 \:0447\:0438\:0441\:0435\:043b ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 ", \:043c\:0435\:043d\:044c\:0448\:0438\:0445 \:0437\:0430\:0434\:0430\:043d\
\:043d\:043e\:0439 \:0433\:0440\:0430\:043d\:0438\:0446\:044b, \:0434\:043b\
\:044f \:043a\:043e\:0442\:043e\:0440\:044b\:0445 2 \:044f\:0432\:043b\:044f\
\:0435\:0442\:0441\:044f \:043f\:0435\:0440\:0432\:043e\:043e\:0431\:0440\
\:0430\:0437\:043d\:044b\:043c \:043a\:043e\:0440\:043d\:0435\:043c."
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
  3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
  3.495972422234375*^9}, {3.495975035734375*^9, 3.495975050765625*^9}, {
  3.495977085640625*^9, 3.49597709015625*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 2.",
  FontWeight->"Bold"],
 " \:0412\:044b\:0447\:0438\:0441\:043b\:0438\:0442\:044c \:043a\:043e\:043b\
\:0438\:0447\:0435\:0441\:0442\:0432\:043e ",
 "\:043d\:0435\:0447\:0435\:0442\:043d\:044b\:0445 ",
 "\:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\
\:0438\:0441\:0435\:043b ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 ", \:043c\:0435\:043d\:044c\:0448\:0438\:0445 \:0437\:0430\:0434\:0430\:043d\
\:043d\:043e\:0439 \:0433\:0440\:0430\:043d\:0438\:0446\:044b, \:0434\:043b\
\:044f \:043a\:043e\:0442\:043e\:0440\:044b\:0445 2 \:044f\:0432\:043b\:044f\
\:0435\:0442\:0441\:044f \:044d\:043b\:0435\:043c\:0435\:043d\:0442\:043e\
\:043c \:043c\:0430\:043a\:0441\:0438\:043c\:0430\:043b\:044c\:043d\:043e\
\:0433\:043e \:043f\:043e\:0440\:044f\:0434\:043a\:0430."
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
   3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
   3.495972422234375*^9}, {3.495975035734375*^9, 3.495975084734375*^9}, 
   3.49597709553125*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\:041a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\:0439\
 \:0437\:0430\:043a\:043e\:043d \:0432\:0437\:0430\:0438\:043c\:043d\:043e\
\:0441\:0442\:0438", "Section",
 CellChangeTimes->{{3.4920562204115896`*^9, 3.49205622552839*^9}, {
  3.495889731*^9, 3.49588974003125*^9}, {3.495889810953125*^9, 
  3.495889817125*^9}}],

Cell["\:0421\:0438\:043c\:0432\:043e\:043b\:044b \:041b\:0435\:0436\:0430\
\:043d\:0434\:0440\:0430 \:0438 \:042f\:043a\:043e\:0431\:0438", "Subsection",
 CellChangeTimes->{{3.495890157546875*^9, 3.495890159578125*^9}, {
  3.496741111234375*^9, 3.496741111234375*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0420\:0430\:0441\:0441\:043c\:043e\:0442\:0440\:0438\:043c \:0441\:0440\
\:0430\:0432\:043d\:0435\:043d\:0438\:0435 \:043f\:043e \:043f\:0440\:043e\
\:0441\:0442\:043e\:043c\:0443 \:043d\:0435\:0447\:0435\:0442\:043d\:043e\
\:043c\:0443 \:043c\:043e\:0434\:0443\:043b\:044e  ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.495972032234375*^9, 3.495972033109375*^9}, {
  3.496741106234375*^9, 3.4967411329375*^9}, {3.496741230921875*^9, 
  3.496741232296875*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], "\[Congruent]", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"mod", " ", "p"}], ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", ",", "p"}], ")"}], "=", "1."}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496741141625*^9, 3.496741183078125*^9}, 
   3.49674122959375*^9}],

Cell[TextData[{
 "\:0415\:0441\:043b\:0438 \:0441\:0440\:0430\:0432\:043d\:0435\:043d\:0438\
\:0435 \:0438\:043c\:0435\:0435\:0442 \:0440\:0435\:0448\:0435\:043d\:0438\
\:0435, \:0431\:0443\:0434\:0435\:043c \:0433\:043e\:0432\:043e\:0440\:0438\
\:0442\:044c, \:0447\:0442\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "- ",
 StyleBox["\:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\
\:0439 \:0432\:044b\:0447\:0435\:0442",
  FontSlant->"Italic"],
 ", \:0432 \:043f\:0440\:043e\:0442\:0438\:0432\:043d\:043e\:043c \
\:0441\:043b\:0443\:0447\:0430\:0435 ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - ",
 StyleBox["\:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\
\:0439 \:043d\:0435\:0432\:044b\:0447\:0435\:0442",
  FontSlant->"Italic"],
 ". \:0418\:0437 \:043c\:0430\:043b\:043e\:0439 \
\:0442\:0435\:043e\:0440\:0435\:043c\:044b \:0424\:0435\:0440\:043c\:0430 \
\:043d\:0435\:043c\:0435\:0434\:043b\:0435\:043d\:043d\:043e \:0441\:043b\
\:0435\:0434\:0443\:0435\:0442, \:0447\:0442\:043e "
}], "Text",
 CellChangeTimes->{{3.49674123465625*^9, 3.4967412715*^9}, 
   3.496741417953125*^9, {3.49674166846875*^9, 3.496741700140625*^9}, {
   3.496741734609375*^9, 3.4967417396875*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         SuperscriptBox["a", 
          FractionBox[
           RowBox[{"p", "-", "1"}], "2"]]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "\[Congruent]", 
      RowBox[{"\[Piecewise]", GridBox[{
         {
          RowBox[{"    ", 
           RowBox[{"1", " ", 
            RowBox[{"(", 
             RowBox[{"mod", " ", "p"}], ")"}]}]}], 
          RowBox[{
           RowBox[{"\:0435\:0441\:043b\:0438", " ", "a"}], " ", "-", " ", 
           RowBox[{
           "\:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\
\:0439", " ", "\:0432\:044b\:0447\:0435\:0442"}]}]},
         {
          RowBox[{
           RowBox[{"-", "1"}], " ", 
           RowBox[{"(", 
            RowBox[{"mod", " ", "p"}], ")"}]}], 
          "\:0438\:043d\:0430\:0447\:0435"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496741743546875*^9, 3.49674179371875*^9}, {
  3.49674203484375*^9, 3.496742043234375*^9}}],

Cell[TextData[{
 "\:0412\:0432\:0435\:0434\:0435\:043c \:0432 \:0440\:0430\:0441\:0441\:043c\
\:043e\:0442\:0440\:0435\:043d\:0438\:0435 ",
 StyleBox["\:0441\:0438\:043c\:0432\:043e\:043b \
\:041b\:0435\:0436\:0430\:043d\:0434\:0440\:0430 ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    FractionBox["a", "p"], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:043e\:043d \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:0442\
\:0441\:044f \:0434\:043b\:044f \:0432\:0441\:0435\:0445 ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043d\:0435 \:0434\:0435\:043b\:044f\:0449\:0438\:0445\:0441\:044f \:043d\
\:0430 ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0438 \:0440\:0430\:0432\:0435\:043d 1, \:0435\:0441\:043b\:0438 ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - \:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\:0439 \
\:0432\:044b\:0447\:0435\:0442 \:0438 -1, \:0435\:0441\:043b\:0438 ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - \:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\:0439 \
\:043d\:0435\:0432\:044b\:0447\:0435\:0442. \:041e\:0447\:0435\:0432\:0438\
\:0434\:043d\:043e"
}], "Text",
 CellChangeTimes->{{3.49674180328125*^9, 3.4967418414375*^9}, {
  3.4967419109375*^9, 3.496742002375*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         SuperscriptBox["a", 
          FractionBox[
           RowBox[{"p", "-", "1"}], "2"]], "\[Congruent]", 
         RowBox[{
          RowBox[{"(", 
           FractionBox["a", "p"], ")"}], "  ", 
          RowBox[{"(", 
           RowBox[{"mod", " ", "p"}], ")"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496742006953125*^9, 3.49674204653125*^9}}],

Cell[TextData[{
 "\:041c\:043e\:0436\:043d\:043e \:043f\:0440\:043e\:0432\:0435\:0440\:0438\
\:0442\:044c, \:0447\:0442\:043e \:043f\:0440\:0438 \:0444\:0438\:043a\:0441\
\:0438\:0440\:043e\:0432\:0430\:043d\:043d\:043e\:043c ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0441\:0438\:043c\:0432\:043e\:043b \:041b\:0435\:0436\:0430\:043d\:0434\
\:0440\:0430 \:0438\:043c\:0435\:0435\:0442 \:043f\:0435\:0440\:0438\:043e\
\:0434 ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0438 \:043c\:0443\:043b\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\
\:0442\:0438\:0432\:0435\:043d. \:0411\:043e\:043b\:0435\:0435 \:0442\:043e\
\:0433\:043e, \:0432 \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0441\:043b\
\:0443\:0447\:0430\:044f\:0445 \:0438\:043c\:0435\:044e\:0442\:0441\:044f \
\:044f\:0432\:043d\:044b\:0435 \:0444\:043e\:0440\:043c\:0443\:043b\:044b \
\:0434\:043b\:044f \:0435\:0433\:043e \:0432\:044b\:0447\:0438\:0441\:043b\
\:0435\:043d\:0438\:044f"
}], "Text",
 CellChangeTimes->{{3.496742384125*^9, 3.49674245575*^9}, {3.4967428615625*^9,
   3.49674289703125*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{GridBox[{
             {
              RowBox[{"(", 
               FractionBox["1", "p"], ")"}]}
            },
            GridBoxAlignment->{"Columns" -> {{"Center"}}}], "=", " ", "1"}], 
          ",", " ", 
          RowBox[{GridBox[{
             {
              RowBox[{"(", 
               FractionBox[
                RowBox[{"-", "1"}], "p"], ")"}]}
            },
            GridBoxAlignment->{"Columns" -> {{"Center"}}}], "=", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            FractionBox[
             RowBox[{"p", "-", "1"}], "2"]]}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        FractionBox["2", "p"], ")"}], "=", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        FractionBox[
         RowBox[{
          SuperscriptBox["p", "2"], "-", "1"}], "8"]]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496742908953125*^9, 3.496743015984375*^9}}],

Cell[TextData[{
 "\:0427\:0442\:043e\:0431\:044b \:0441\:0434\:0435\:043b\:0430\:0442\:044c \
\:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\:0435 \:0441\:0438\
\:043c\:0432\:043e\:043b\:0430 \:041b\:0435\:0436\:0430\:043d\:0434\:0440\
\:0430 \:0431\:043e\:043b\:0435\:0435 \:0431\:044b\:0441\:0442\:0440\:044b\
\:043c, \:0440\:0430\:0441\:0441\:043c\:0430\:0442\:0440\:0438\:0432\:0430\
\:044e\:0442 \:0431\:043e\:043b\:0435\:0435 \:043e\:0431\:0449\:0438\:0439 ",
 StyleBox["\:0441\:0438\:043c\:0432\:043e\:043b \
\:042f\:043a\:043e\:0431\:0438. ",
  FontSlant->"Italic"],
 "\:041f\:0443\:0441\:0442\:044c ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", "1"], "\[CenterDot]", "\[CenterDot]", "\[CenterDot]", 
      SubscriptBox["p", "r"]}], ">", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - \:043d\:0435\:0447\:0435\:0442\:043d\:043e\:0435, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", "i"], ",", 
    RowBox[{"i", "=", 
     RowBox[{
      RowBox[{"1", "..."}], "r"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - \:043f\:0440\:043e\:0441\:0442\:044b\:0435, \:0431\:044b\:0442\:044c \
\:043c\:043e\:0436\:0435\:0442, \:043f\:043e\:0432\:0442\:043e\:0440\:044f\
\:044e\:0449\:0438\:0435\:0441\:044f. \:0418 \:043f\:0443\:0441\:0442\:044c \
\:0434\:0430\:043b\:0435\:0435 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", ",", "P"}], ")"}], "=", "1."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0422\:043e\:0433\:0434\:0430 \:0441\:0438\:043c\:0432\:043e\:043b \:042f\
\:043a\:043e\:0431\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     FractionBox["a", "P"], ")"}], " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:0442\:0441\:044f \
\:0440\:0430\:0432\:0435\:043d\:0441\:0442\:0432\:043e\:043c"
}], "Text",
 CellChangeTimes->{{3.4967424629375*^9, 3.4967426598125*^9}, {
  3.496742720078125*^9, 3.496742730390625*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"(", 
       FractionBox[GridBox[{
          {"a"}
         },
         GridBoxAlignment->{"Columns" -> {{"Center"}}}], "P"], ")"}], " ", 
      "=", " ", 
      RowBox[{
       RowBox[{"(", 
        FractionBox["a", 
         SubscriptBox["p", "1"]], ")"}], "\[CenterDot]", "\[CenterDot]", 
       "\[CenterDot]", 
       RowBox[{"(", 
        FractionBox["a", 
         SubscriptBox["p", "r"]], ")"}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496742710515625*^9, 3.496742758359375*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", ",", "P"}], ")"}], "\[NotEqual]", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043f\:043e\:043b\:043e\:0436\:0438\:043c ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     FractionBox["a", "P"], ")"}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:041e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:043d\:044b\:0439 \
\:0442\:0430\:043a\:0438\:043c \:043e\:0431\:0440\:0430\:0437\:043e\:043c \
\:0441\:0438\:043c\:0432\:043e\:043b \:042f\:043a\:043e\:0431\:0438 \:043d\
\:0430\:0441\:043b\:0435\:0434\:0443\:0435\:0442 \:0432\:0441\:0435 \:0443\
\:043f\:043e\:043c\:044f\:043d\:0443\:0442\:044b\:0435 \:0441\:0432\:043e\
\:0439\:0441\:0442\:0432\:0430 \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \
\:041b\:0435\:0436\:0430\:043d\:0434\:0440\:0430 \:0432 \:0441\:043b\:0443\
\:0447\:0430\:0435 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", ",", "P"}], ")"}], "=", "1."}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.496742764984375*^9, 3.496742839484375*^9}, {
  3.496743030640625*^9, 3.49674306609375*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\
\:044f \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \:042f\:043a\:043e\:0431\
\:0438 (\:0438 \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \:041b\:0435\:0436\
\:0430\:043d\:0434\:0440\:0430) \:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0438\:043c\:0435\:0435\:0442\:0441\:044f \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ",
 StyleBox["JacobiSymbol, ",
  FontWeight->"Bold"],
 "\:043d\:0430\:043f\:0440\:0438\:043c\:0435\:0440"
}], "Text",
 CellChangeTimes->{{3.496743078515625*^9, 3.496743114609375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"2", ",", "P"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JacobiSymbol", "[", 
   RowBox[{"3", ",", "P"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", "91"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"2", ",", "p"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"5", ",", "p"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4959720415*^9, 3.495972050421875*^9}, {
  3.49674314590625*^9, 3.49674326675*^9}, {3.4967433094375*^9, 
  3.496743368515625*^9}}]
}, Closed]],

Cell["\:041a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\:0439\
 \:0437\:0430\:043a\:043e\:043d \:0432\:0437\:0430\:0438\:043c\:043d\:043e\
\:0441\:0442\:0438", "Subsection",
 CellChangeTimes->{{3.495890177734375*^9, 3.49589017978125*^9}, {
  3.496743445734375*^9, 3.496743445734375*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 "\t\:0421\:0438\:043c\:0432\:043e\:043b \:041b\:0435\:0436\:0430\:043d\:0434\
\:0440\:0430 \:0438\:043c\:0435\:0435\:0442 \:043e\:0434\:043d\:043e \:0441\
\:0432\:043e\:0439\:0441\:0442\:0432\:043e, \:043f\:043e\:0437\:0432\:043e\
\:043b\:044f\:044e\:0449\:0435\:0435 \:0432\:044b\:0447\:0438\:0441\:043b\
\:044f\:0442\:044c \:0435\:0433\:043e \:0434\:043e\:0441\:0442\:0430\:0442\
\:043e\:0447\:043d\:043e \:0431\:044b\:0441\:0442\:0440\:043e. \:042d\:0442\
\:043e \:0441\:0432\:043e\:0439\:0441\:0442\:0432\:0430 \:043d\:0430\:0437\
\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:044b\
\:043c \:0437\:0430\:043a\:043e\:043d\:043e\:043c \:0432\:0437\:0430\:0438\
\:043c\:043d\:043e\:0441\:0442\:0438",
  FontSlant->"Italic"],
 " \:0438 \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \
\:0441\:0444\:043e\:0440\:043c\:0443\:043b\:0438\:0440\:043e\:0432\:0430\:043d\
\:043e \:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0438\:043c \:043e\:0431\
\:0440\:0430\:0437\:043e\:043c: \:0435\:0441\:043b\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", ",", "q"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " - \:043f\:0440\:043e\:0441\:0442\:044b\:0435 \
\:043d\:0435\:0447\:0435\:0442\:043d\:044b\:0435, \:0442\:043e"
}], "Text",
 CellChangeTimes->{{3.4959720590625*^9, 3.495972060125*^9}, {
  3.4967434471875*^9, 3.49674356428125*^9}, {3.496743617953125*^9, 
  3.49674361903125*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"(", 
           FractionBox["q", "p"], ")"}], " ", "=", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{
            FractionBox[
             RowBox[{"p", "-", "1"}], "2"], "\[CenterDot]", 
            FractionBox[
             RowBox[{"q", "-", "1"}], "2"]}]]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], 
      RowBox[{
       RowBox[{"(", 
        FractionBox["p", "q"], ")"}], "."}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.4967435413125*^9, 3.49674361046875*^9}}],

Cell[TextData[{
 "\:0410\:043d\:0430\:043b\:043e\:0433\:0438\:0447\:043d\:044b\:043c \:0441\
\:0432\:043e\:0439\:0441\:0442\:0432\:043e\:043c \:043e\:0431\:043b\:0430\
\:0434\:0430\:0435\:0442 \:0438 \:0441\:0438\:043c\:0432\:043e\:043b \:042f\
\:043a\:043e\:0431\:0438, \:0434\:043e\:0441\:0442\:0430\:0442\:043e\:0447\
\:043d\:043e \:043b\:0438\:0448\:044c \:0437\:0430\:043c\:0435\:043d\:0438\
\:0442\:044c \:0442\:0440\:0435\:0431\:043e\:0432\:0430\:043d\:0438\:0435 \
\:043f\:0440\:043e\:0441\:0442\:043e\:0442\:044b ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", ",", "q"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043d\:0430 \:0442\:0440\:0435\:0431\:043e\:0432\:0430\:043d\:0438\:0435 \
\:0438\:0445 \:0432\:0437\:0430\:0438\:043c\:043d\:043e\:0439 \:043f\:0440\
\:043e\:0441\:0442\:043e\:0442\:044b \:0438 \:043d\:0435\:0447\:0435\:0442\
\:043d\:043e\:0441\:0442\:0438."
}], "Text",
 CellChangeTimes->{{3.4967436148125*^9, 3.4967436895625*^9}, {
  3.4967442163125*^9, 3.49674422121875*^9}}],

Cell[TextData[{
 "\:041f\:0440\:043e\:0446\:0435\:0441\:0441 \:0432\:044b\:0447\:0438\:0441\
\:043b\:0435\:043d\:0438\:044f \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \
\:042f\:043a\:043e\:0431\:0438 (\:041b\:0435\:0436\:0430\:043d\:0434\:0440\
\:0430) \:043f\:0440\:0438 \:043f\:043e\:043c\:043e\:0449\:0438 \:043a\:0432\
\:0430\:0434\:0440\:0430\:0442\:0438\:0447\:043d\:043e\:0433\:043e \:0437\
\:0430\:043a\:043e\:043d\:0430 \:0432\:0437\:0430\:0438\:043c\:043d\:043e\
\:0441\:0442\:0438 \:0432\:044b\:0433\:043b\:044f\:0434\:0438\:0442 \:0441\
\:043b\:0435\:0434\:0443\:044e\:0449\:0438\:043c \:043e\:0431\:0440\:0430\
\:0437\:043e\:043c. \:041f\:0443\:0441\:0442\:044c ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", ",", "P"}], ")"}], "=", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0435\:0441\:043b\:0438 \:044d\:0442\:043e \:043d\:0435 \:0442\:0430\
\:043a, \:0447\:0442\:043e \:043f\:043e \:043e\:043f\:0440\:0435\:0434\:0435\
\:043b\:0435\:043d\:0438\:044e ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     FractionBox["a", "P"], ")"}], "=", "0."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0411\:0443\:0434\:0435\:043c \:0442\:0430\:043a\:0436\:0435 \:0441\:0447\
\:0438\:0442\:0430\:0442\:044c, \:0447\:0442\:043e ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "<", "P"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0438\:043d\:0430\:0447\:0435 \:0437\:0430\:043c\:0435\:043d\:0438\:043c \
",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043d\:0430 \:043e\:0441\:0442\:0430\:0442\:043e\:043a \:043e\:0442 \
\:0434\:0435\:043b\:0435\:043d\:0438\:044f \:043d\:0430 ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0432\:0441\:0438\:043b\:0443 \:043f\:0435\:0440\:0435\:043e\:0434\:0438\
\:0447\:043d\:043e\:0441\:0442\:0438 \:0437\:043d\:0430\:0447\:0435\:043d\
\:0438\:0435 \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \:043d\:0435 \:0438\
\:0437\:043c\:0435\:043d\:0438\:0442\:0441\:044f. \:0412\:044b\:043d\:0435\
\:0441\:0435\:043c \:0438\:0437 ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:043c\:0430\:043a\:0441\:0438\:043c\:0430\:043b\:044c\:043d\:0443\:044e \
\:0441\:0442\:0435\:043f\:0435\:043d\:044c 2, \:0438 \:0432\:043e\:0441\:043f\
\:043e\:043b\:044c\:0437\:0443\:0435\:043c\:0441\:044f \:043c\:0443\:043b\
\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:043e\
\:0441\:0442\:044c\:044e \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \:0438 \
\:0444\:043e\:0440\:043c\:0443\:043b\:043e\:0439"
}], "Text",
 CellChangeTimes->{{3.4967436958125*^9, 3.496743734015625*^9}, {
   3.496743771953125*^9, 3.496743990765625*^9}, {3.496744110640625*^9, 
   3.49674418675*^9}, 3.49674431253125*^9}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{"(", 
          FractionBox["a", "P"], ")"}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "=", 
      RowBox[{
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          SuperscriptBox["2", "k"], 
          RowBox[{"a", "'"}]}], "P"], ")"}], "=", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["2", "P"], ")"}], "k"], 
         RowBox[{"(", 
          FractionBox[
           RowBox[{"a", "'"}], "P"], ")"}]}], "=", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           FractionBox[
            RowBox[{
             SuperscriptBox["P", "2"], "-", "1"}], "8"], "k"}]], 
         RowBox[{"(", 
          FractionBox[
           RowBox[{"a", "'"}], "P"], ")"}]}]}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496744193171875*^9, 3.49674429903125*^9}}],

Cell["\<\
 \:0412\:043e\:0441\:043f\:043e\:043b\:044c\:0437\:0443\:0435\:043c\:0441\
\:044f \:0442\:0435\:043f\:0435\:0440\:044c \:0437\:0430\:043a\:043e\:043d\
\:043e\:043c \:0432\:0437\:0430\:0438\:043c\:043d\:043e\:0441\:0442\:0438, \
\:043f\:043e\:043b\:0443\:0447\:0438\:043c\
\>", "Text",
 CellChangeTimes->{{3.4967436958125*^9, 3.496743734015625*^9}, {
  3.496743771953125*^9, 3.496743990765625*^9}, {3.496744110640625*^9, 
  3.496744168609375*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{GridBox[{
           {
            RowBox[{
             RowBox[{"(", 
              FractionBox[
               RowBox[{"a", "'"}], "P"], ")"}], " ", "=", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], 
              RowBox[{
               FractionBox[
                RowBox[{
                 RowBox[{"a", "'"}], "-", "1"}], "2"], "\[CenterDot]", 
               FractionBox[
                RowBox[{"P", "-", "1"}], "2"]}]]}]}
          },
          GridBoxAlignment->{"Columns" -> {{"Center"}}}], 
         RowBox[{
          RowBox[{"(", 
           FractionBox["P", 
            RowBox[{"a", "'"}]], ")"}], "."}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.496743950109375*^9, 3.496743976421875*^9}, {
  3.496744320125*^9, 3.496744332921875*^9}}],

Cell[TextData[{
 "\:0414\:043b\:044f ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    FractionBox["P", 
     RowBox[{"a", "'"}]], ")"}], TraditionalForm]]],
 " \:043f\:0440\:043e\:0434\:0435\:043b\:0430\:0435\:043c \:0430\:043d\:0430\
\:043b\:043e\:0433\:0438\:0447\:043d\:044b\:0435 \:043e\:043f\:0435\:0440\
\:0430\:0446\:0438\:0438. \:041f\:0440\:0438 \:044d\:0442\:043e\:043c \:0432\
\:0441\:0438\:043b\:0443 \:043f\:0435\:0440\:0435\:043e\:0434\:0438\:0447\
\:043d\:043e\:0441\:0442\:0438 \:0441\:0438\:043c\:0432\:043e\:043b\:0430 \
\:0447\:0438\:0441\:043b\:0438\:0442\:0435\:043b\:044c \:0431\:0443\:0434\
\:0435\:0442 \:0432\:0441\:0435 \:0432\:0440\:0435\:043c\:044f \:0443\:043c\
\:0435\:043d\:044c\:0448\:0430\:0442\:044c\:0441\:044f, \:043f\:043e\:043a\
\:0430 \:043d\:0435 \:0434\:0430\:0441\:0442 \:043b\:0438\:0431\:043e \:043f\
\:043e\:043b\:043d\:0443\:044e \:0441\:0442\:0435\:043f\:0435\:043d\:044c 2, \
\:043b\:0438\:0431\:043e 1."
}], "Text",
 CellChangeTimes->{{3.49674434359375*^9, 3.496744413796875*^9}}],

Cell[TextData[{
 "\:041f\:0440\:043e\:0438\:043b\:043b\:044e\:0441\:0442\:0440\:0438\:0440\
\:0443\:0435\:043c \:044d\:0442\:043e\:0442 \:043f\:0440\:043e\:0446\:0435\
\:0441\:0441 \:043f\:0440\:043e\:0433\:0440\:0430\:043c\:043c\:043e\:0439 \
\:0432 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.49674442184375*^9, 3.496744437*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "3"}], ";", 
  RowBox[{"P", "=", "12344321"}], ";", " ", 
  RowBox[{"JacobiSymbol", "[", 
   RowBox[{"a", ",", "P"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{"a", ",", "P"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"a", ">", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"a", ",", "P"}], "]"}], "\[NotEqual]", " ", "1"}], ",", " ", 
       RowBox[{
        RowBox[{"s", "=", "0"}], ";", " ", 
        RowBox[{"a", "=", "1"}], ";", 
        RowBox[{"P", "=", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"Divisible", "[", 
        RowBox[{"a", ",", "2"}], "]"}], ",", 
       RowBox[{
        RowBox[{"s", "*=", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          FractionBox[
           RowBox[{
            SuperscriptBox["P", "2"], "-", "1"}], "8"]]}], ";", 
        RowBox[{"a", "/=", "2"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", " ", "*=", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"P", "-", "1"}], ")"}]}], "4"]]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"t", "=", "a"}], ";", 
     RowBox[{"a", "=", "P"}], ";", 
     RowBox[{"P", "=", "t"}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"a", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{"a", ",", "P"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", "s", "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.496744442703125*^9, 3.496744590390625*^9}, {
  3.49674465128125*^9, 3.4967447521875*^9}, {3.4967447950625*^9, 
  3.496744983140625*^9}, {3.496745034828125*^9, 3.4967452301875*^9}, {
  3.49674526575*^9, 3.496745323390625*^9}, {3.496745355859375*^9, 
  3.496745415515625*^9}}]
}, Closed]],

Cell["\:0417\:0430\:0434\:0430\:0447\:0438", "Subsection",
 CellChangeTimes->{{3.4958901858125*^9, 3.4958901878125*^9}, {
  3.4967454441875*^9, 3.49674544521875*^9}}],

Cell[CellGroupData[{

Cell["", "Subsection"],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 1.",
  FontWeight->"Bold"],
 " \:0414\:043b\:044f \:0437\:0430\:0434\:0430\:043d\:043d\:043e\:0433\:043e \
\:043d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:043e\:0433\:043e ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]],
  FormatType->"TraditionalForm"],
 "  \:043f\:043e\:0441\:0442\:0440\:043e\:0438\:0442\:044c \:043f\:0440\:043e\
\:0441\:0442\:043e\:0435 ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0447\:0442\:043e \:0432\:0441\:0435 \:0447\:0438\:0441\:043b\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "..."}], "n", " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\:044f\:0432\:043b\:044f\:044e\:0442\:0441\:044f \:043a\:0432\:0430\:0434\
\:0440\:0430\:0442\:0438\:0447\:043d\:044b\:043c\:0438 \:0432\:044b\:0447\
\:0435\:0442\:0430\:043c\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", "p"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.495972086734375*^9, 3.495972235484375*^9}, {
  3.4959722671875*^9, 3.495972366703125*^9}, {3.495972418078125*^9, 
  3.495972422234375*^9}, {3.495975035734375*^9, 3.495975050765625*^9}, {
  3.495975441625*^9, 3.49597544384375*^9}, {3.4959756368125*^9, 
  3.495975664921875*^9}, {3.4959758856875*^9, 3.495975980078125*^9}, {
  3.49597637434375*^9, 3.49597637684375*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 2.",
  FontWeight->"Bold"],
 " \:0412\:044b\:0447\:0438\:0441\:043b\:0438\:0442\:044c \:043a\:043e\:043b\
\:0438\:0447\:0435\:0441\:0442\:0432\:043e \:043d\:0430\:0442\:0443\:0440\
\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\:0438\:0441\:0435\:043b ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:043c\:0435\:043d\:044c\:0448\:0438\:0445 \:0437\:0430\:0434\:0430\:043d\
\:043d\:043e\:0439 \:0433\:0440\:0430\:043d\:0438\:0446\:044b, \:0434\:043b\
\:044f \:043a\:043e\:0442\:043e\:0440\:044b\:0445 7 \:044f\:0432\:043b\:044f\
\:0435\:0442\:0441\:044f \:043a\:0432\:0430\:0434\:0440\:0430\:0442\:0438\
\:0447\:043d\:044b\:043c \:0432\:044b\:0447\:0435\:0442\:043e\:043c."
}], "Text",
 CellChangeTimes->{{3.4959763673125*^9, 3.49597639165625*^9}, 
   3.495976432875*^9}],

Cell[BoxData[""], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1272, 937},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->FrontEnd`FileName[{"Book"}, "Textbook.nb", 
  CharacterEncoding -> "WindowsCyrillic"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 123, 2, 217, "BookChapterNumber"],
Cell[693, 26, 291, 4, 194, "BookChapterTitle"],
Cell[CellGroupData[{
Cell[1009, 34, 292, 4, 86, "Section"],
Cell[1304, 40, 240, 4, 51, "Subsection"],
Cell[CellGroupData[{
Cell[1569, 48, 22, 0, 36, "Subsection"],
Cell[1594, 50, 2053, 42, 121, "Text"],
Cell[3650, 94, 311, 6, 147, "Input"],
Cell[3964, 102, 3202, 63, 195, "Text"],
Cell[7169, 167, 149, 3, 64, "Input"],
Cell[7321, 172, 774, 13, 85, "Text"],
Cell[8098, 187, 227, 4, 106, "Input"],
Cell[8328, 193, 556, 9, 48, "Text"],
Cell[8887, 204, 734, 12, 85, "Text"],
Cell[9624, 218, 2325, 56, 88, "Text"],
Cell[11952, 276, 235, 3, 48, "Text"],
Cell[12190, 281, 558, 10, 268, "Input"],
Cell[12751, 293, 1195, 23, 85, "Text"],
Cell[13949, 318, 591, 17, 79, "Text"],
Cell[14543, 337, 418, 14, 48, "Text"],
Cell[14964, 353, 618, 18, 106, "Input"]
}, Closed]],
Cell[15597, 374, 522, 8, 36, "Subsection"],
Cell[CellGroupData[{
Cell[16144, 386, 22, 0, 36, "Subsection"],
Cell[16169, 388, 2628, 58, 159, "Text"],
Cell[18800, 448, 3336, 72, 195, "Text"],
Cell[22139, 522, 1938, 47, 121, "Text"],
Cell[24080, 571, 685, 12, 147, "Input"],
Cell[24768, 585, 270, 5, 48, "Text"],
Cell[25041, 592, 585, 14, 187, "Input"],
Cell[25629, 608, 1551, 34, 85, "Text"],
Cell[27183, 644, 1409, 38, 51, "Text"],
Cell[28595, 684, 425, 11, 48, "Text"],
Cell[29023, 697, 2000, 50, 360, "Input"]
}, Closed]],
Cell[31038, 750, 365, 5, 36, "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited}],
Cell[CellGroupData[{
Cell[31428, 759, 22, 0, 36, "Subsection"],
Cell[31453, 761, 1012, 30, 48, "Text"],
Cell[32468, 793, 1786, 46, 88, "Text"],
Cell[34257, 841, 758, 15, 85, "Text"],
Cell[35018, 858, 333, 5, 147, "Input"],
Cell[35354, 865, 1670, 31, 121, "Text"],
Cell[37027, 898, 1085, 32, 70, "Text"]
}, Closed]],
Cell[38127, 933, 313, 5, 36, "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited}],
Cell[CellGroupData[{
Cell[38465, 942, 22, 0, 36, "Subsection"],
Cell[38490, 944, 1767, 43, 121, "Text"],
Cell[40260, 989, 351, 6, 147, "Input"],
Cell[40614, 997, 445, 7, 48, "Text"],
Cell[41062, 1006, 1373, 41, 57, "Text"],
Cell[42438, 1049, 261, 6, 48, "Text"],
Cell[42702, 1057, 1243, 37, 235, "Input"],
Cell[43948, 1096, 514, 8, 48, "Text"],
Cell[44465, 1106, 639, 19, 64, "Text"],
Cell[45107, 1127, 151, 2, 48, "Text"],
Cell[45261, 1131, 398, 11, 139, "Input"]
}, Closed]],
Cell[45674, 1145, 223, 3, 36, "Subsection",
 CellGroupingRules->{"SectionGrouping", Inherited}],
Cell[CellGroupData[{
Cell[45922, 1152, 22, 0, 36, "Subsection"],
Cell[45947, 1154, 651, 15, 48, "Text"],
Cell[46601, 1171, 627, 20, 70, "Text"],
Cell[47231, 1193, 294, 9, 48, "Text"],
Cell[47528, 1204, 654, 14, 48, "Text"],
Cell[48185, 1220, 1204, 38, 94, "Text"],
Cell[49392, 1260, 307, 9, 48, "Text"],
Cell[49702, 1271, 1168, 25, 85, "Text"],
Cell[50873, 1298, 464, 11, 48, "Text"],
Cell[51340, 1311, 623, 16, 69, "Text"],
Cell[51966, 1329, 440, 12, 48, "Text"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52455, 1347, 350, 5, 54, "Section"],
Cell[52808, 1354, 338, 6, 51, "Subsection"],
Cell[CellGroupData[{
Cell[53171, 1364, 22, 0, 36, "Subsection"],
Cell[53196, 1366, 1528, 36, 85, "Text"],
Cell[54727, 1404, 742, 19, 48, "Text"],
Cell[55472, 1425, 727, 22, 52, "Text"],
Cell[56202, 1449, 996, 25, 48, "Text"],
Cell[57201, 1476, 501, 15, 51, "Text"],
Cell[57705, 1493, 1164, 25, 85, "Text"],
Cell[58872, 1520, 447, 8, 106, "Input"],
Cell[59322, 1530, 518, 10, 48, "Text"],
Cell[59843, 1542, 991, 31, 48, "Text"],
Cell[60837, 1575, 2594, 63, 118, "Text"],
Cell[63434, 1640, 1005, 21, 85, "Text"],
Cell[64442, 1663, 157, 3, 64, "Input"],
Cell[64602, 1668, 840, 20, 85, "Text"],
Cell[65445, 1690, 238, 4, 106, "Input"]
}, Closed]],
Cell[65698, 1697, 240, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[65963, 1704, 22, 0, 36, "Subsection"],
Cell[65988, 1706, 2219, 54, 121, "Text"],
Cell[68210, 1762, 1421, 23, 121, "Text"],
Cell[69634, 1787, 502, 8, 228, "Input"],
Cell[70139, 1797, 513, 10, 48, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[70689, 1812, 119, 1, 36, "Subsection"],
Cell[70811, 1815, 1063, 18, 85, "Text"],
Cell[71877, 1835, 1113, 20, 85, "Text"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[73039, 1861, 342, 5, 54, "Section"],
Cell[73384, 1868, 268, 3, 51, "Subsection"],
Cell[CellGroupData[{
Cell[73677, 1875, 22, 0, 36, "Subsection"],
Cell[73702, 1877, 555, 11, 48, "Text"],
Cell[74260, 1890, 622, 19, 52, "Text"],
Cell[74885, 1911, 1332, 29, 85, "Text"],
Cell[76220, 1942, 1684, 45, 82, "Text"],
Cell[77907, 1989, 1472, 35, 115, "Text"],
Cell[79382, 2026, 589, 18, 88, "Text"],
Cell[79974, 2046, 1163, 22, 85, "Text"],
Cell[81140, 2070, 1230, 39, 100, "Text"],
Cell[82373, 2111, 2073, 50, 142, "Text"],
Cell[84449, 2163, 652, 21, 82, "Text"],
Cell[85104, 2186, 1252, 31, 106, "Text"],
Cell[86359, 2219, 612, 13, 48, "Text"],
Cell[86974, 2234, 688, 17, 309, "Input"]
}, Closed]],
Cell[87677, 2254, 304, 4, 36, "Subsection"],
Cell[CellGroupData[{
Cell[88006, 2262, 22, 0, 36, "Subsection"],
Cell[88031, 2264, 1487, 26, 121, "Text"],
Cell[89521, 2292, 760, 24, 88, "Text"],
Cell[90284, 2318, 1015, 18, 85, "Text"],
Cell[91302, 2338, 2880, 59, 180, "Text"],
Cell[94185, 2399, 1106, 37, 93, "Text"],
Cell[95294, 2438, 456, 8, 48, "Text"],
Cell[95753, 2448, 1036, 31, 82, "Text"],
Cell[96792, 2481, 1030, 19, 106, "Text"],
Cell[97825, 2502, 378, 9, 48, "Text"],
Cell[98206, 2513, 2237, 61, 603, "Input"]
}, Closed]],
Cell[100458, 2577, 166, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[100649, 2583, 22, 0, 36, "Subsection"],
Cell[100674, 2585, 1427, 33, 85, "Text"],
Cell[102104, 2620, 875, 16, 85, "Text"],
Cell[102982, 2638, 26, 0, 64, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
